/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.endpoint2;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.net.endpoint2.AbstractEndPoint;
import ch.nolix.core.resourcecontrol.closecontroller.CloseController;
import ch.nolix.coreapi.net.endpoint2.IServer;
import ch.nolix.coreapi.net.endpoint2.ISlot;
import ch.nolix.coreapi.resourcecontrol.closecontroller.ICloseController;

public abstract class AbstractServer
implements IServer {
    private final ICloseController closeController = CloseController.forElement(this);
    private ISlot defaultSlot;
    private final LinkedList<ISlot> slots = LinkedList.createEmpty();

    @Override
    public final void addDefaultSlot(ISlot defaultSlot) {
        this.addSlotToList(defaultSlot);
        this.defaultSlot = defaultSlot;
        this.noteAddedDefaultSlot(defaultSlot);
    }

    @Override
    public final void addSlot(ISlot slot) {
        this.addSlotToList(slot);
        this.noteAddedSlot(slot);
    }

    @Override
    public final void clear() {
        this.slots.forEach(this::removeSlot);
    }

    @Override
    public final boolean containsDefaultSlot() {
        return this.defaultSlot != null;
    }

    @Override
    public final boolean containsSlotWithName(String name) {
        return this.slots.containsAny(ept -> ept.hasName(name));
    }

    @Override
    public final ICloseController getStoredCloseController() {
        return this.closeController;
    }

    @Override
    public final boolean isEmpty() {
        return this.slots.isEmpty();
    }

    @Override
    public final void noteClose() {
    }

    @Override
    public final void removeSlotByName(String name) {
        this.removeSlot(this.slots.getStoredFirst(s -> s.hasName(name)));
    }

    final void internalTakeBackendEndPoint(AbstractEndPoint abstractEndPoint) {
        abstractEndPoint.assertIsOpen();
        if (!abstractEndPoint.hasCustomTargetSlot()) {
            this.getStoredDefaultSlot().takeBackendEndPoint(abstractEndPoint);
        } else {
            this.getStoredSlotByName(abstractEndPoint.getCustomTargetSlot()).takeBackendEndPoint(abstractEndPoint);
        }
    }

    protected abstract void noteAddedDefaultSlot(ISlot var1);

    protected abstract void noteAddedSlot(ISlot var1);

    protected abstract void noteRemovedSlot(ISlot var1);

    private void addSlotToList(ISlot slot) {
        this.assertDoesNotContainSlotWithName(slot.getName());
        this.slots.addAtEnd(slot);
    }

    private void assertContainsDefaultSlot() {
        if (!this.containsDefaultSlot()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "default end point taker");
        }
    }

    private void assertDoesNotContainSlotWithName(String name) {
        if (this.containsSlotWithName(name)) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "contains already a Slot with the name '" + name + "'");
        }
    }

    private ISlot getStoredDefaultSlot() {
        this.assertContainsDefaultSlot();
        return this.defaultSlot;
    }

    private ISlot getStoredSlotByName(String name) {
        return this.slots.getStoredFirst(ept -> ept.hasName(name));
    }

    private void removeSlot(ISlot slot) {
        this.slots.removeStrictlyFirstOccurrenceOf(slot);
        if (slot == this.defaultSlot) {
            this.defaultSlot = null;
        }
        this.noteRemovedSlot(slot);
    }
}

