/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.endpoint2;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.net.endpoint2.AbstractServer;
import ch.nolix.core.net.endpoint2.NetEndPoint;
import ch.nolix.coreapi.net.endpoint.IEndPoint;
import ch.nolix.coreapi.net.endpoint.ISlot;

final class ServerSlot
implements ISlot {
    private final String name;
    private final AbstractServer parentServer;

    public ServerSlot(String name, AbstractServer parentServer) {
        Validator.assertThat(name).thatIsNamed("name").isNotBlank();
        Validator.assertThat(parentServer).thatIsNamed("parent server").isNotNull();
        this.parentServer = parentServer;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void takeBackendEndPoint(IEndPoint endPoint) {
        this.parentServer.internalTakeBackendEndPoint(new NetEndPoint(endPoint));
    }
}

