/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.endpoint3;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ClosedArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.net.baseendpoint.AbstractBaseEndPoint;
import ch.nolix.core.programcontrol.flowcontrol.FlowController;
import ch.nolix.coreapi.document.chainednode.IChainedNode;
import ch.nolix.coreapi.net.endpoint3.IDataProviderController;
import ch.nolix.coreapi.net.endpoint3.IEndPoint;

public abstract class AbstractEndPoint
extends AbstractBaseEndPoint
implements IEndPoint {
    private static final int CONNECT_TIMEOUT_IN_MILLISECONDS = 500;
    private IDataProviderController receiverController;

    AbstractEndPoint() {
    }

    @Override
    public final boolean hasReceivingDataProviderController() {
        return this.receiverController != null;
    }

    @Override
    public final void runCommands(IChainedNode command, IChainedNode ... commands) {
        this.runCommand(command);
        IChainedNode[] iChainedNodeArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            IChainedNode c = iChainedNodeArray[n2];
            this.runCommand(c);
            ++n2;
        }
    }

    @Override
    public final void noteClose() {
    }

    @Override
    public final void setReceivingDataProviderController(IDataProviderController receiverController) {
        Validator.assertThat(receiverController).thatIsNamed("receiver controller").isNotNull();
        this.receiverController = receiverController;
    }

    protected void assertIsOpen() {
        if (this.isClosed()) {
            throw ClosedArgumentException.forArgument(this);
        }
    }

    IDataProviderController getStoredReceiverController() {
        if (this.hasReceivingDataProviderController()) {
            return this.receiverController;
        }
        FlowController.forMaxMilliseconds(500).waitUntil(this::hasReceivingDataProviderController);
        if (!this.hasReceivingDataProviderController()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "receiver");
        }
        return this.receiverController;
    }
}

