/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.endpoint3;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.net.endpoint3.AbstractEndPoint;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.chainednode.IChainedNode;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.coreapi.net.endpoint3.IDataProviderController;
import ch.nolix.coreapi.net.endpoint3.ISlot;
import ch.nolix.coreapi.net.netproperty.ConnectionType;
import ch.nolix.coreapi.net.netproperty.PeerType;
import ch.nolix.coreapi.net.securityproperty.SecurityMode;

public final class LocalEndPoint
extends AbstractEndPoint {
    private final PeerType peerType;
    private final LocalEndPoint counterpart;
    private final String target;

    public LocalEndPoint() {
        this.peerType = PeerType.FRONTEND;
        this.counterpart = new LocalEndPoint(this);
        this.target = null;
    }

    public LocalEndPoint(ISlot target) {
        this.peerType = PeerType.FRONTEND;
        this.counterpart = new LocalEndPoint(this, target.getName());
        this.target = null;
        target.takeBackendEndPoint(this.getStoredCounterpart());
    }

    private LocalEndPoint(LocalEndPoint counterpart) {
        this.peerType = PeerType.BACKEND;
        Validator.assertThat(counterpart).thatIsNamed("counterpart").isNotNull();
        this.counterpart = counterpart;
        this.createCloseDependencyTo(counterpart);
        this.target = null;
    }

    private LocalEndPoint(LocalEndPoint counterpart, String target) {
        this.peerType = PeerType.BACKEND;
        Validator.assertThat(counterpart).thatIsNamed("counterpart").isNotNull();
        this.counterpart = counterpart;
        Validator.assertThat(target).thatIsNamed("target").isNotEmpty();
        this.target = target;
    }

    @Override
    public ConnectionType getConnectionType() {
        return ConnectionType.LOCAL;
    }

    @Override
    public INode<?> getDataForRequest(IChainedNode request) {
        return this.counterpart.getStoredReceiverController().getDataForRequest(request);
    }

    @Override
    public IContainer<? extends INode<?>> getDataForRequests(IChainedNode request, IChainedNode ... requests) {
        return this.counterpart.getStoredReceiverController().getDataForRequests(request, requests);
    }

    @Override
    public IContainer<? extends INode<?>> getDataForRequests(Iterable<? extends IChainedNode> requests) {
        return this.counterpart.getStoredReceiverController().getDataForRequests(requests);
    }

    public LocalEndPoint getStoredCounterpart() {
        return this.counterpart;
    }

    @Override
    public String getCustomTargetSlot() {
        return this.target;
    }

    @Override
    public PeerType getPeerType() {
        return this.peerType;
    }

    @Override
    public SecurityMode getSecurityMode() {
        return SecurityMode.NONE;
    }

    @Override
    public boolean hasCustomTargetSlot() {
        return this.target != null;
    }

    @Override
    public void runCommand(IChainedNode command) {
        this.assertIsOpen();
        this.counterpart.getStoredReceiverController().runCommand(command);
    }

    @Override
    public void runCommands(Iterable<? extends IChainedNode> commands) {
        this.assertIsOpen();
        IDataProviderController counterpartReceiverController = this.counterpart.getStoredReceiverController();
        commands.forEach(counterpartReceiverController::runCommand);
    }
}

