/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.endpoint3;

import ch.nolix.core.net.endpoint3.AbstractServer;
import ch.nolix.core.net.endpoint3.ServerSlot;
import ch.nolix.core.net.ssl.NolixConfigurationSSLCertificateReader;
import ch.nolix.coreapi.net.endpoint3.ISlot;
import ch.nolix.coreapi.net.securityproperty.SecurityMode;
import ch.nolix.coreapi.net.ssl.ISslCertificate;

public final class SslServer
extends AbstractServer {
    private static final NolixConfigurationSSLCertificateReader NOLIX_CONFIUGEATION_SSL_CERTIFICATE_READER = new NolixConfigurationSSLCertificateReader();
    private final ch.nolix.core.net.endpoint2.SslServer internalWebSocketServer;

    private SslServer(int port, String HtmlPage, ISslCertificate paramSSLCertificate) {
        this.internalWebSocketServer = new ch.nolix.core.net.endpoint2.SslServer(port, HtmlPage, paramSSLCertificate);
        this.createCloseDependencyTo(this.internalWebSocketServer);
    }

    public static SslServer forPortAndHtmlPageAndSSLCertificate(int port, String htmlPage, ISslCertificate sslCertificate) {
        return new SslServer(port, htmlPage, sslCertificate);
    }

    public static SslServer forPortAndHtmlPageAndSSLCertificateFromNolixConfiguration(int port, String htmlPage) {
        ISslCertificate sslCertificate = NOLIX_CONFIUGEATION_SSL_CERTIFICATE_READER.getDefaultSSLCertificatefromLocalNolixConfiguration();
        return new SslServer(port, htmlPage, sslCertificate);
    }

    @Override
    public SecurityMode getSecurityMode() {
        return SecurityMode.SSL;
    }

    @Override
    protected void noteAddedDefaultSlot(ISlot defaultSlot) {
        this.internalWebSocketServer.addDefaultSlot(new ServerSlot(defaultSlot.getName(), this));
    }

    @Override
    protected void noteAddedSlot(ISlot slot) {
        this.internalWebSocketServer.addSlot(new ServerSlot(slot.getName(), this));
    }

    @Override
    protected void noteRemovedSlot(ISlot slot) {
        this.internalWebSocketServer.removeSlotByName(slot.getName());
    }
}

