/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.programcontrol.jobpool;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.programcontrol.jobpool.Future;
import ch.nolix.core.programcontrol.jobpool.JobWrapper;
import ch.nolix.core.programcontrol.jobpool.Worker;
import ch.nolix.coreapi.programcontrol.future.IFuture;
import java.util.Optional;

public final class JobPool {
    private static final int OPTIMAL_WORKER_COUNT = 100;
    private final LinkedList<Worker> workers = LinkedList.createEmpty();
    private final LinkedList<JobWrapper> jobWrappers = LinkedList.createEmpty();

    public IFuture enqueue(Runnable job) {
        JobWrapper jobWrapper = new JobWrapper(job);
        this.jobWrappers.addAtEnd(jobWrapper);
        this.createNewWorkerIfNeeded();
        return new Future(jobWrapper);
    }

    public boolean containsWaitingJobs() {
        return this.jobWrappers.containsAny(JobWrapper::isFresh);
    }

    public boolean isIdle() {
        return this.jobWrappers.containsAny();
    }

    synchronized Optional<JobWrapper> removeAndGetOptionalRefNextFreshJobWrapper() {
        Optional<JobWrapper> nextFreshJobWrapper = this.jobWrappers.getOptionalStoredFirst(JobWrapper::isFresh);
        if (nextFreshJobWrapper.isEmpty()) {
            return Optional.empty();
        }
        this.jobWrappers.removeStrictlyFirstOccurrenceOf(nextFreshJobWrapper.get());
        return Optional.of(nextFreshJobWrapper.get());
    }

    synchronized void removeWorker(Worker worker) {
        this.workers.removeStrictlyFirstOccurrenceOf(worker);
    }

    private synchronized void createNewWorkerIfNeeded() {
        if (this.newWorkerIsNeeded()) {
            this.workers.addAtEnd(new Worker(this));
        }
    }

    private int getOptimalWorkerCount() {
        return 100;
    }

    private int getWorkerCount() {
        return this.workers.getCount();
    }

    private synchronized boolean newWorkerIsNeeded() {
        int workerCount = this.getWorkerCount();
        return this.jobWrappers.containsAny() && workerCount < this.getOptimalWorkerCount() && 10 * workerCount < this.jobWrappers.getCount();
    }
}

