/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.resourcecontrol.closecontroller;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentContainsElementException;
import ch.nolix.core.errorcontrol.logging.Logger;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.programcontrol.processproperty.CloseState;
import ch.nolix.coreapi.resourcecontrol.closecontroller.GroupCloseable;
import ch.nolix.coreapi.resourcecontrol.closecontroller.IClosePool;

final class ClosePool
implements IClosePool {
    private CloseState state = CloseState.OPEN;
    private final LinkedList<GroupCloseable> elements = LinkedList.createEmpty();

    public ClosePool(GroupCloseable element) {
        this.addElement(element);
    }

    public static ClosePool forElement(GroupCloseable element) {
        return new ClosePool(element);
    }

    @Override
    public void addElements(IContainer<GroupCloseable> elements) {
        elements.forEach(this::addElement);
    }

    @Override
    public void closeElementsIfStateIsOpen() {
        if (this.getState() == CloseState.OPEN) {
            this.closeElementsWhenStateIsOpen();
        }
    }

    @Override
    public IContainer<GroupCloseable> getStoredElements() {
        return this.elements;
    }

    @Override
    public CloseState getState() {
        return this.state;
    }

    private void addElement(GroupCloseable element) {
        this.assertDoesNotContainElement(element);
        this.elements.addAtEnd(element);
    }

    private void assertDoesNotContainElement(GroupCloseable element) {
        if (this.containsElement(element)) {
            throw ArgumentContainsElementException.forArgumentAndElement(this, element);
        }
    }

    private void closeElementsWhenStateIsOpen() {
        this.state = CloseState.ON_CLOSING;
        this.elements.forEach(this::letNoteClose);
        this.state = CloseState.CLOSED;
    }

    private boolean containsElement(GroupCloseable element) {
        return this.elements.contains(element);
    }

    private void letNoteClose(GroupCloseable element) {
        try {
            element.noteClose();
        }
        catch (Throwable exception) {
            Logger.logError(exception);
        }
    }
}

