/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.sql.model;

import ch.nolix.core.container.arraylist.AbstractExtendedContainer;
import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsNullException;
import ch.nolix.core.errorcontrol.invalidargumentexception.NonPositiveArgumentException;
import ch.nolix.coreapi.container.iterator.CopyableIterator;
import ch.nolix.coreapi.sql.model.ISqlRecord;

public final class SqlRecord
extends AbstractExtendedContainer<String>
implements ISqlRecord {
    private final int oneBasedIndex;
    private final ImmutableList<String> values;

    private SqlRecord(int oneBasedIndex, ImmutableList<String> values) {
        if (oneBasedIndex < 1) {
            throw NonPositiveArgumentException.forArgumentAndArgumentName(oneBasedIndex, "one-based index");
        }
        if (values == null) {
            throw ArgumentIsNullException.forArgumentName("values");
        }
        this.oneBasedIndex = oneBasedIndex;
        this.values = values;
    }

    public static SqlRecord withOneBasedIndexAndValue(int oneBasedIndex, String value) {
        ImmutableList<String> values = ImmutableList.withElement(value, new String[0]);
        return SqlRecord.withOneBasedIndexAndValues(oneBasedIndex, values);
    }

    public static SqlRecord withOneBasedIndexAndValues(int oneBasedIndex, Iterable<String> values) {
        return new SqlRecord(oneBasedIndex, ImmutableList.forIterable(values));
    }

    @Override
    public int getCount() {
        return this.values.getCount();
    }

    @Override
    public int getOneBasedIndex() {
        return this.oneBasedIndex;
    }

    @Override
    public String getStoredAtOneBasedIndex(int oneBasedIndex) {
        return this.values.getStoredAtOneBasedIndex(oneBasedIndex);
    }

    @Override
    public boolean isMaterialized() {
        return true;
    }

    @Override
    public CopyableIterator<String> iterator() {
        return this.values.iterator();
    }
}

