/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.sql.sqltool;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.sql.connection.ISqlConnection;
import ch.nolix.coreapi.sql.sqltool.ISqlCollector;

public final class SqlCollector
implements ISqlCollector {
    private final LinkedList<String> sqlStatements = LinkedList.createEmpty();

    @Override
    public SqlCollector addSqlStatement(String sqlstatement, String ... sqlStatements) {
        this.addSingleSqlStatement(sqlstatement);
        this.addSqlStatements(ContainerView.forArray(sqlStatements, new String[0][]));
        return this;
    }

    @Override
    public SqlCollector addSqlStatements(Iterable<String> sqlStatements) {
        sqlStatements.forEach(string -> {
            SqlCollector sqlCollector = this.addSqlStatement((String)string, new String[0]);
        });
        return this;
    }

    @Override
    public void clear() {
        this.sqlStatements.clear();
    }

    @Override
    public void executeAndClearUsingConnection(ISqlConnection sqlConnection) {
        try {
            this.executeUsingConnection(sqlConnection);
        }
        finally {
            this.clear();
        }
    }

    @Override
    public IContainer<String> getSqlStatements() {
        return this.sqlStatements;
    }

    @Override
    public boolean isEmpty() {
        return this.sqlStatements.isEmpty();
    }

    private void addSingleSqlStatement(String sqlstatement) {
        Validator.assertThat(sqlstatement).thatIsNamed("SQL statement").isNotBlank();
        this.sqlStatements.addAtEnd(sqlstatement);
    }

    private void executeUsingConnection(ISqlConnection sqlConnection) {
        sqlConnection.executeStatements(this.sqlStatements);
    }
}

