/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.web.htmlelementmodel;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.web.htmlelementmodel.HtmlAttribute;
import ch.nolix.core.web.htmlelementmodel.HtmlElementStringRepresentator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.web.htmlelementmodel.IHtmlAttribute;
import ch.nolix.coreapi.web.htmlelementmodel.IHtmlElement;

public final class HtmlElement
implements IHtmlElement {
    private static final HtmlElementStringRepresentator HTML_ELEMENT_STRING_REPRESENTATOR = new HtmlElementStringRepresentator();
    private final String type;
    private final String innerText;
    private final IContainer<HtmlAttribute> attributes;
    private final IContainer<HtmlElement> childElements;

    private HtmlElement(String type, IContainer<? extends IHtmlAttribute> attributes, String innerText, IContainer<? extends IHtmlElement> childElements) {
        Validator.assertThat(type).thatIsNamed("type").isNotBlank();
        Validator.assertThat(innerText).thatIsNamed("inner text").isNotNull();
        this.type = type;
        this.attributes = attributes.to(HtmlAttribute::fromHtmlAttribute);
        this.innerText = innerText;
        this.childElements = childElements.to(HtmlElement::fromHtmlElement);
    }

    public static HtmlElement fromHtmlElement(IHtmlElement htmlElement) {
        if (htmlElement instanceof HtmlElement) {
            HtmlElement htmlAttribute = (HtmlElement)htmlElement;
            return htmlAttribute;
        }
        return HtmlElement.withTypeAndAttributesAndChildElements(htmlElement.getType(), htmlElement.getAttributes(), htmlElement.getChildElements());
    }

    public static HtmlElement withType(String type) {
        return new HtmlElement(type, ImmutableList.createEmpty(), "", ImmutableList.createEmpty());
    }

    public static HtmlElement withTypeAndAttribute(String type, IHtmlAttribute attribute, IHtmlAttribute ... attributes) {
        return new HtmlElement(type, ImmutableList.withElement(attribute, attributes), "", ImmutableList.createEmpty());
    }

    public static HtmlElement withTypeAndAttributeAndChildElement(String type, IHtmlAttribute attribute, IHtmlElement childElement) {
        return new HtmlElement(type, ImmutableList.withElement(attribute, new IHtmlAttribute[0]), "", ImmutableList.withElement(childElement, new IHtmlElement[0]));
    }

    public static HtmlElement withTypeAndAttributes(String type, IContainer<? extends IHtmlAttribute> attributes) {
        return new HtmlElement(type, attributes, "", ImmutableList.createEmpty());
    }

    public static HtmlElement withTypeAndAttributesAndChildElement(String type, IContainer<? extends IHtmlAttribute> attributes, IHtmlElement childElement, IHtmlElement ... childElements) {
        ImmutableList<IHtmlElement> allChildElements = ImmutableList.withElement(childElement, childElements);
        return new HtmlElement(type, attributes, "", allChildElements);
    }

    public static HtmlElement withTypeAndAttributesAndChildElements(String type, IContainer<? extends IHtmlAttribute> attributes, IContainer<? extends IHtmlElement> childElements) {
        return new HtmlElement(type, attributes, "", childElements);
    }

    public static HtmlElement withTypeAndAttributesAndInnerText(String type, IContainer<? extends IHtmlAttribute> attributes, String innerText) {
        return new HtmlElement(type, attributes, innerText, ImmutableList.createEmpty());
    }

    public static HtmlElement withTypeAndChildElement(String type, IHtmlElement childElement, IHtmlElement ... childElements) {
        return new HtmlElement(type, ImmutableList.createEmpty(), "", ImmutableList.withElement(childElement, childElements));
    }

    public static HtmlElement withTypeAndChildElements(String type, IContainer<? extends IHtmlElement> childElements) {
        return new HtmlElement(type, ImmutableList.createEmpty(), "", childElements);
    }

    public static HtmlElement withTypeAndInnerText(String type, String innerText) {
        return new HtmlElement(type, ImmutableList.createEmpty(), innerText, ImmutableList.createEmpty());
    }

    @Override
    public boolean containsAttributes() {
        return this.getAttributes().containsAny();
    }

    @Override
    public boolean containsChildElements() {
        return this.getChildElements().containsAny();
    }

    @Override
    public IContainer<? extends IHtmlAttribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public IContainer<? extends IHtmlElement> getChildElements() {
        return this.childElements;
    }

    @Override
    public String getInnerText() {
        return this.innerText;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public boolean equals(Object object) {
        if (object instanceof HtmlElement) {
            HtmlElement htmlElement = (HtmlElement)object;
            return this.getType().equals(htmlElement.getType()) && this.getAttributes().containsExactlyEqualingInSameOrder(htmlElement.getAttributes()) && this.getChildElements().containsExactlyEqualingInSameOrder(htmlElement.getChildElements()) && this.getInnerText().equals(htmlElement.getInnerText());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return HTML_ELEMENT_STRING_REPRESENTATOR.toString(this);
    }

    @Override
    public IHtmlElement withAttribute(IHtmlAttribute attribute, IHtmlAttribute ... attributes) {
        ContainerView<? extends IHtmlAttribute> allAttributes = ContainerView.forIterable(this.getAttributes(), ContainerView.forElementAndArray(attribute, attributes));
        if (this.containsChildElements()) {
            return HtmlElement.withTypeAndAttributesAndChildElements(this.getType(), allAttributes, this.getChildElements());
        }
        return HtmlElement.withTypeAndAttributesAndInnerText(this.getType(), allAttributes, this.getInnerText());
    }
}

