/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.application.main;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.misc.dataobject.VoidObject;
import ch.nolix.core.resourcecontrol.closecontroller.CloseController;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.coreapi.net.endpoint3.IEndPoint;
import ch.nolix.coreapi.resourcecontrol.closecontroller.ICloseController;
import ch.nolix.system.application.main.AbstractBackendClient;
import ch.nolix.system.application.main.AbstractSession;
import ch.nolix.system.application.main.Application;
import ch.nolix.system.application.main.BasicApplication;
import ch.nolix.systemapi.application.main.IApplication;
import ch.nolix.systemapi.application.main.IServer;

public abstract class AbstractServer<S extends AbstractServer<S>>
implements IServer<S> {
    private final ICloseController closeController = CloseController.forElement(this);
    private Application<?, ?> defaultApplication;
    private final ILinkedList<Application<?, ?>> applications = LinkedList.createEmpty();

    @Override
    public final S addApplication(IApplication<?, ?> application) {
        Application localApplication = (Application)application;
        localApplication.setParentServer(this);
        this.addApplicationToList(localApplication);
        this.noteAddedApplication(localApplication);
        return this.asConcrete();
    }

    public final S addApplicationWithNameAddendum(Application<?, ?> application, String nameAddendum) {
        application.setParentServer(this);
        application.setNameAppendix(nameAddendum);
        this.addApplicationToList(application);
        this.noteAddedApplication(application);
        return this.asConcrete();
    }

    public final <T extends AbstractSession<C, U>, C extends AbstractBackendClient<C, U>, U> S addApplicationWithNameAndInitialSessionClassAndContext(String applicationName, Class<T> initialSessionClass, U applicationService) {
        BasicApplication application = BasicApplication.withNameAndInitialSessionClassAndContext(applicationName, initialSessionClass, applicationService);
        return (S)this.addApplication((IApplication)application);
    }

    public final <T extends AbstractSession<C, Object>, C extends AbstractBackendClient<C, Object>> S addApplicationWithNameAndInitialSessionClassAndVoidContext(String name, Class<T> initialSessionClass) {
        BasicApplication application = BasicApplication.withNameAndInitialSessionClassAndContext(name, initialSessionClass, new VoidObject());
        return (S)this.addApplication((IApplication)application);
    }

    public final <C extends AbstractBackendClient<C, U>, U> S addDefaultApplication(Application<C, U> defaultApplication) {
        defaultApplication.setParentServer(this);
        this.addApplicationToList(defaultApplication);
        this.defaultApplication = defaultApplication;
        this.noteAddedDefaultApplication(defaultApplication);
        return this.asConcrete();
    }

    public final <T extends AbstractSession<C, U>, C extends AbstractBackendClient<C, U>, U> S addDefaultApplicationWithNameAndInitialSessionClassAndContext(String applicationName, Class<T> initialSessionClass, U applicationService) {
        BasicApplication localDefaultApplication = BasicApplication.withNameAndInitialSessionClassAndContext(applicationName, initialSessionClass, applicationService);
        return this.addDefaultApplication(localDefaultApplication);
    }

    public final <T extends AbstractSession<C, Object>, C extends AbstractBackendClient<C, Object>> S addDefaultApplicationWithNameAndInitialSessionClassAndVoidContext(String name, Class<T> initialSessionClass) {
        BasicApplication localDefaultApplication = BasicApplication.withNameAndInitialSessionClassAndContext(name, initialSessionClass, new VoidObject());
        return this.addDefaultApplication(localDefaultApplication);
    }

    @Override
    public final void clear() {
        this.getStoredApplications().forEach(this::removeApplication);
    }

    public final boolean containsDefaultApplication() {
        return this.defaultApplication != null;
    }

    public final boolean containsApplicationWithName(String name) {
        return this.applications.containsAny(a -> a.getInstanceName().equals(name));
    }

    public final Application<?, ?> getStoredApplicationByInstanceName(String instanceName) {
        return this.applications.getStoredFirst(a -> a.getInstanceName().equals(instanceName));
    }

    public final Application<?, ?> getStoredApplicationByUrlInstanceName(String urlInstanceName) {
        return this.applications.getStoredFirst(a -> a.getUrlInstanceName().equals(urlInstanceName));
    }

    @Override
    public final IContainer<? extends IApplication<?, ?>> getStoredApplications() {
        return this.applications;
    }

    @Override
    public final ICloseController getStoredCloseController() {
        return this.closeController;
    }

    public final Application<?, ?> getStoredDefaultApplication() {
        this.assertContainsDefaultApplication();
        return this.defaultApplication;
    }

    @Override
    public final boolean isEmpty() {
        return this.getStoredApplications().isEmpty();
    }

    public final boolean hasClientConnected() {
        return this.applications.containsAny(Application::hasClientConnected);
    }

    @Override
    public final void noteClose() {
    }

    @Override
    public final void removeApplicationWithInstanceName(String instanceName) {
        Application<?, ?> application = this.getStoredApplicationByInstanceName(instanceName);
        this.removeApplication(application);
    }

    public final void takeClient(AbstractBackendClient<?, ?> client) {
        if (!client.hasUrlInstanceNameOfTargetApplication()) {
            this.getStoredDefaultApplication().takeClient(client);
        } else {
            String targetApplicaitonUrlInstanceName = client.getUrlInstanceNameOfTargetApplication();
            this.getStoredApplicationByUrlInstanceName(targetApplicaitonUrlInstanceName).takeClient(client);
        }
    }

    protected abstract S asConcrete();

    protected abstract void noteAddedApplication(Application<?, ?> var1);

    protected abstract void noteAddedDefaultApplication(Application<?, ?> var1);

    protected abstract void noteRemovedApplication(IApplication<?, ?> var1);

    void internalTakeEndPoint(IEndPoint endPoint) {
        if (!endPoint.hasCustomTargetSlot()) {
            this.getStoredDefaultApplication().takeEndPoint(endPoint);
        } else {
            this.getStoredApplicationByUrlInstanceName(endPoint.getCustomTargetSlot()).takeEndPoint(endPoint);
        }
    }

    private void addApplicationToList(Application<?, ?> application) {
        this.assertDoesNotContainApplicationWithName(application.getInstanceName());
        this.applications.addAtEnd(application);
    }

    private void assertContainsDefaultApplication() {
        if (!this.containsDefaultApplication()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "default Application");
        }
    }

    private void assertDoesNotContainApplicationWithName(String name) {
        if (this.containsApplicationWithName(name)) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "contains already an Application with the name '" + name + "'");
        }
    }

    private void removeApplication(IApplication<?, ?> application) {
        this.applications.removeStrictlyFirstOccurrenceOf(application);
        if (application == this.defaultApplication) {
            this.defaultApplication = null;
        }
        this.noteRemovedApplication(application);
    }
}

