/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.element.multistateconfiguration;

import ch.nolix.core.commontypetool.stringtool.StringExaminer;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.commontypetool.stringtool.IStringExaminer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.element.multistateconfiguration.AbstractProperty;
import ch.nolix.system.element.multistateconfiguration.State;
import ch.nolix.system.element.multistateconfiguration.StateProperty;
import ch.nolix.systemapi.element.multistateconfiguration.ValueStoringState;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;

public abstract class AbstractMaterializedProperty<S extends Enum<S>, V>
extends AbstractProperty<S> {
    private static final String NONE_HEADER = "None";
    private static final IStringExaminer STRING_EXAMINER = new StringExaminer();
    private final Function<INode<?>, V> valueCreator;
    private final Function<V, INode<?>> specificationCreator;
    private final BiConsumer<S, V> setterMethod;
    protected final StateProperty<V>[] stateProperties;

    protected AbstractMaterializedProperty(String name, Class<S> stateClass, Function<INode<?>, V> valueCreator, Function<V, INode<?>> specificationCreator) {
        super(name);
        Validator.assertThat(valueCreator).thatIsNamed("value creator").isNotNull();
        Validator.assertThat(specificationCreator).thatIsNamed("specification creator").isNotNull();
        this.stateProperties = new StateProperty[((Enum[])stateClass.getEnumConstants()).length];
        this.valueCreator = valueCreator;
        this.specificationCreator = specificationCreator;
        this.setterMethod = null;
        this.extractStateProperties();
    }

    protected AbstractMaterializedProperty(String name, Class<S> stateClass, Function<INode<?>, V> valueCreator, Function<V, INode<?>> specificationCreator, BiConsumer<S, V> setterMethod) {
        super(name);
        Validator.assertThat(valueCreator).thatIsNamed("value creator").isNotNull();
        Validator.assertThat(specificationCreator).thatIsNamed("specification creator").isNotNull();
        Validator.assertThat(setterMethod).thatIsNamed("setter method").isNotNull();
        this.stateProperties = new StateProperty[((Enum[])stateClass.getEnumConstants()).length];
        this.valueCreator = valueCreator;
        this.specificationCreator = specificationCreator;
        this.setterMethod = setterMethod;
        this.extractStateProperties();
    }

    public final ValueStoringState getAssignmentTypeForState(S state) {
        return this.stateProperties[this.getStateOf(state).getIndex()].getAssignmentType();
    }

    public final Optional<V> getOptionalValueOfState(S state) {
        StateProperty<V> stateProperty = this.stateProperties[this.getStateOf(state).getIndex()];
        if (!stateProperty.hasValue()) {
            return Optional.empty();
        }
        return Optional.of(stateProperty.getValue());
    }

    public final V getValueOfState(S state) {
        return this.stateProperties[this.getStateOf(state).getIndex()].getValue();
    }

    public final V getValueWhenHasState(S state) {
        return this.getValueWhenHasState(this.getStateOf(state));
    }

    public final boolean hasSetterMethod() {
        return this.setterMethod != null;
    }

    public final boolean hasValueForState(S state) {
        return this.stateProperties[this.getStateOf(state).getIndex()].hasValue();
    }

    public final boolean hasValueOrIsEmptyForState(S state) {
        return this.stateProperties[this.getStateOf(state).getIndex()].hasValueOrDefinesEmpty();
    }

    @Override
    public void setUndefined() {
        StateProperty<V>[] statePropertyArray = this.stateProperties;
        int n = this.stateProperties.length;
        int n2 = 0;
        while (n2 < n) {
            StateProperty<V> sp = statePropertyArray[n2];
            sp.setForwarding();
            ++n2;
        }
    }

    public void setUndefinedForState(S state) {
        this.stateProperties[this.getStateOf(state).getIndex()].setForwarding();
    }

    public final void setValueForState(S state, V value) {
        this.stateProperties[this.getStateOf(state).getIndex()].setValue(value);
    }

    @Override
    protected final void fillUpValuesSpecificationInto(ILinkedList<INode<?>> list) {
        for (State state : this.parent.getAvailableStates()) {
            StateProperty<V> stateProperty = this.stateProperties[state.getIndex()];
            switch (stateProperty.getAssignmentType()) {
                case STORING_VALUE: {
                    Node valueSpecification = Node.withHeaderAndChildNode(state.getQualifyingPrefix() + this.getName(), this.specificationCreator.apply(stateProperty.getValue()).getStoredSingleChildNode(), new INode[0]);
                    list.addAtEnd(valueSpecification);
                    break;
                }
                case DEFINING_EMPTY: {
                    list.addAtEnd(Node.withHeaderAndChildNode(state.getQualifyingPrefix() + this.getName(), NONE_HEADER, new String[0]));
                    break;
                }
            }
        }
    }

    protected final StateProperty<V> getStoredBaseStateProperty() {
        return this.stateProperties[this.parent.getBaseStateObject().getIndex()];
    }

    protected final State<S> getStateOf(S state) {
        return this.parent.getStateObjectFor(state);
    }

    protected abstract V getValueWhenHasState(State<S> var1);

    protected abstract boolean hasValueWhenHasState(State<S> var1);

    @Override
    protected void setFrom(AbstractProperty<S> property) {
        this.setFrom((AbstractMaterializedProperty)property);
    }

    @Override
    protected final void setValueFromSpecification(INode<?> specification) {
        for (State state : this.parent.getAvailableStates()) {
            if (!STRING_EXAMINER.startsWithIgnoringCase(specification.getHeader(), state.getQualifyingPrefix())) continue;
            this.setValueFromSpecificationToState(state, specification);
            return;
        }
        throw InvalidArgumentException.forArgumentAndArgumentName(specification, "specification");
    }

    private void extractStateProperties() {
        int i = 0;
        while (i < this.stateProperties.length) {
            this.stateProperties[i] = StateProperty.createUndefinedStateProperty();
            ++i;
        }
    }

    private void setFrom(AbstractMaterializedProperty<S, V> materializedProperty) {
        int i = 0;
        while (i < this.stateProperties.length) {
            switch (materializedProperty.stateProperties[i].getAssignmentType()) {
                case STORING_VALUE: {
                    this.stateProperties[i].setValue(materializedProperty.stateProperties[i].getValue());
                    break;
                }
                case DEFINING_EMPTY: {
                    this.stateProperties[i].setEmpty();
                    break;
                }
                case FORWARDING: {
                    this.stateProperties[i].setForwarding();
                }
            }
            ++i;
        }
    }

    private void setValueForStateUsingSetterMethod(S state, V value) {
        if (this.setterMethod == null) {
            this.setValueForState(state, value);
        } else {
            this.setterMethod.accept(state, value);
        }
    }

    private void setValueFromSpecificationToState(State<S> state, INode<?> specification) {
        if (specification.getSingleChildNodeHeader().equals(NONE_HEADER)) {
            this.stateProperties[state.getIndex()].setEmpty();
        } else {
            this.setValueForStateUsingSetterMethod(state.getEnumValue(), this.valueCreator.apply(specification));
        }
    }
}

