/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.element.property;

import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.systemapi.element.mutableelement.IMutableElement;
import ch.nolix.systemapi.element.property.IProperty;

public abstract class AbstractSubElement<E extends IMutableElement>
implements IProperty {
    private final String attributePrefix;
    private E internalSubElement;

    protected AbstractSubElement(String attributePrefix, E internalSubElement) {
        Validator.assertThat(attributePrefix).thatIsNamed("attribute prefix").isNotBlank();
        this.attributePrefix = attributePrefix;
        this.internalSetSubElement(internalSubElement);
    }

    public String getAttributePrefix() {
        return this.attributePrefix;
    }

    public E getSubElement() {
        return this.internalSubElement;
    }

    public abstract boolean isExchangable();

    @Override
    public final boolean addedOrChangedAttribute(INode<?> attribute) {
        if (attribute.hasHeader() && attribute.getHeader().startsWith(this.attributePrefix)) {
            this.internalSubElement.addOrChangeAttribute(Node.withHeaderAndChildNodes(attribute.getHeader().substring(this.attributePrefix.length()), attribute.getStoredChildNodes()));
            return true;
        }
        return false;
    }

    @Override
    public void fillUpAttributesInto(ILinkedList<INode<?>> list) {
        for (INode iNode : this.internalSubElement.getAttributes()) {
            list.addAtEnd(Node.withHeaderAndChildNodes(this.attributePrefix + iNode.getHeader(), iNode.getStoredChildNodes()));
        }
    }

    protected final void internalSetSubElement(E internalSubElement) {
        Validator.assertThat(internalSubElement).thatIsNamed("sub element").isNotNull();
        if (this.internalSubElement != null && !this.isExchangable()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "is not exchangable");
        }
        this.internalSubElement = internalSubElement;
    }
}

