/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.element.property;

import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.attribute.mandatoryattribute.INameHolder;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.systemapi.element.property.IProperty;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class ForwardingMutableValue<V>
implements IProperty,
INameHolder {
    private final String name;
    private final Consumer<V> setter;
    private final Supplier<V> getter;
    private final Function<INode<?>, V> valueCreator;
    private final Function<V, INode<?>> specificationCreator;

    public ForwardingMutableValue(String name, Consumer<V> setter, Supplier<V> getter, Function<INode<?>, V> valueCreator, Function<V, INode<?>> specificationCreator) {
        Validator.assertThat(name).thatIsNamed("name").isNotBlank();
        Validator.assertThat(setter).thatIsNamed("setter").isNotNull();
        Validator.assertThat(getter).thatIsNamed("getter").isNotNull();
        Validator.assertThat(valueCreator).thatIsNamed("value creator").isNotNull();
        Validator.assertThat(specificationCreator).thatIsNamed("specification creator").isNotNull();
        this.name = name;
        this.setter = setter;
        this.getter = getter;
        this.valueCreator = valueCreator;
        this.specificationCreator = specificationCreator;
    }

    public static ForwardingMutableValue<Boolean> forBoolean(String name, Consumer<Boolean> setter, Supplier<Boolean> getter) {
        return new ForwardingMutableValue<Boolean>(name, setter, getter, INode::getSingleChildNodeAsBoolean, Node::withChildNode);
    }

    public static ForwardingMutableValue<Integer> forInt(String name, Consumer<Integer> setter, Supplier<Integer> getter) {
        return new ForwardingMutableValue<Integer>(name, setter, getter, INode::getSingleChildNodeAsInt, Node::withChildNode);
    }

    public static ForwardingMutableValue<String> forString(String name, Consumer<String> setter, Supplier<String> getter) {
        return new ForwardingMutableValue<String>(name, setter, getter, s -> s.getStoredSingleChildNode().getHeaderOrEmptyString(), s -> {
            if (s.isEmpty()) {
                return Node.EMPTY_NODE;
            }
            return Node.withChildNode(s, new String[0]);
        });
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean addedOrChangedAttribute(INode<?> attribute) {
        if (this.hasName(attribute.getHeader())) {
            this.setter.accept(this.valueCreator.apply(attribute));
            return true;
        }
        return false;
    }

    @Override
    public void fillUpAttributesInto(ILinkedList<INode<?>> list) {
        list.addAtEnd(this.specificationCreator.apply(this.getter.get()));
    }
}

