/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.graphic.color;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.datastructure.pair.Pair;
import ch.nolix.core.reflection.reflectiontool.ReflectionTool;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.coreapi.datastructure.pair.IPair;
import ch.nolix.system.graphic.color.Color;
import ch.nolix.systemapi.graphic.color.IColor;
import java.lang.reflect.Field;

public final class X11ColorCatalogExtractor {
    private static final String STRING_CONSTANT_POSTFIX = "_STRING";

    public IContainer<IPair<String, IColor>> getColorConstantsFromClass(Class<?> paramClass) {
        LinkedList<IPair<String, IColor>> x11Colors = LinkedList.createEmpty();
        ILinkedList<Field> colorStringFields = this.getColorNameConstantFields(paramClass);
        ILinkedList<Field> colorFields = this.getColorFields(paramClass);
        for (Field csf : colorStringFields) {
            String colorStringFieldName = csf.getName();
            Field colorField = colorFields.removeAndGetStoredFirst(cf -> colorStringFieldName.startsWith(cf.getName()));
            x11Colors.addAtEnd(new Pair<String, IColor>((String)ReflectionTool.getValueOfStaticField(csf), (IColor)ReflectionTool.getValueOfStaticField(colorField)));
        }
        return x11Colors;
    }

    private boolean declaresColor(Field field) {
        return ReflectionTool.isStatic(field) && ReflectionTool.canStoreValueOfTypeOrSuperType(field, Color.class);
    }

    private boolean declaresColorName(Field field) {
        return ReflectionTool.isStatic(field) && field.getName().endsWith(STRING_CONSTANT_POSTFIX);
    }

    private ILinkedList<Field> getColorFields(Class<?> paramClass) {
        LinkedList<Field> colorFields = LinkedList.createEmpty();
        Field[] fieldArray = paramClass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (this.declaresColor(f)) {
                colorFields.addAtEnd(f);
            }
            ++n2;
        }
        return colorFields;
    }

    private ILinkedList<Field> getColorNameConstantFields(Class<?> paramClass) {
        LinkedList<Field> colorNameConstantFields = LinkedList.createEmpty();
        Field[] fieldArray = paramClass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (this.declaresColorName(f)) {
                colorNameConstantFields.addAtEnd(f);
            }
            ++n2;
        }
        return colorNameConstantFields;
    }
}

