/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.gui.frontend;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.environment.filesystem.FileAccessor;
import ch.nolix.core.environment.filesystem.FileSystemAccessor;
import ch.nolix.core.errorcontrol.generalexception.WrapperException;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.systemapi.gui.frontend.IFrontEndReader;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public final class LocalFrontEndReader
implements IFrontEndReader {
    private static final JFileChooser FILE_CHOOSER;

    static {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            throw WrapperException.forError(exception);
        }
        FILE_CHOOSER = new JFileChooser();
    }

    @Override
    public IContainer<byte[]> getFilesFromClipboard() {
        return this.getFilePathsFromClipboard().to(FileSystemAccessor::readFileToBytes);
    }

    @Override
    public String getTextFromClipboard() {
        try {
            return Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor).toString();
        }
        catch (UnsupportedFlavorException | IOException exception) {
            throw WrapperException.forError(exception);
        }
    }

    @Override
    public Optional<byte[]> readFileToBytes() {
        if (FILE_CHOOSER.showOpenDialog(null) != 0) {
            return Optional.empty();
        }
        String filePath = FILE_CHOOSER.getSelectedFile().getPath();
        return Optional.of(new FileAccessor(filePath).readFileToBytes());
    }

    private IContainer<String> getFilePathsFromClipboard() {
        try {
            List files = (List)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.javaFileListFlavor);
            return ContainerView.forIterable(files, new Iterable[0]).to(File::getPath);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            throw WrapperException.forError(exception);
        }
    }
}

