/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.nodemiddata.datawriter;

import ch.nolix.core.document.node.MutableNode;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.programcontrol.process.UpdaterCollector;
import ch.nolix.coreapi.document.node.IMutableNode;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.coreapi.programcontrol.process.IUpdaterCollector;
import ch.nolix.system.nodemiddata.datawriter.DataWriterActionProvider;
import ch.nolix.systemapi.middata.model.EntityUpdateDto;
import ch.nolix.systemapi.midschemaview.model.TableViewDto;
import ch.nolix.systemapi.time.moment.ITime;
import java.util.function.Consumer;

public final class ExecutiveDataWriter {
    private final IMutableNode<?> nodeDatabase;
    private final IUpdaterCollector<IMutableNode<?>> updaterCollector = new UpdaterCollector();
    private int saveCount;

    private ExecutiveDataWriter(IMutableNode<?> nodeDatabase) {
        Validator.assertThat(nodeDatabase).thatIsNamed("node database").isNotNull();
        this.nodeDatabase = nodeDatabase;
    }

    public static ExecutiveDataWriter forNodeDatabase(IMutableNode<?> nodeDatabase) {
        return new ExecutiveDataWriter(nodeDatabase);
    }

    public void clearMultiReference(String tableName, String entityId, int multiReferencedColumnOneBasedOrdinalIndex) {
        Consumer<IMutableNode> updateAction = d -> DataWriterActionProvider.clearMultiReference(d, tableName, entityId, multiReferencedColumnOneBasedOrdinalIndex);
        this.updaterCollector.addUpdater(updateAction);
    }

    public void clearMultiValue(String tableName, String entityId, int multiValueColumnOneBasedOrdinalIndex) {
        Consumer<IMutableNode> updateAction = d -> DataWriterActionProvider.clearMultiValue(d, tableName, entityId, multiValueColumnOneBasedOrdinalIndex);
        this.updaterCollector.addUpdater(updateAction);
    }

    public void deleteMultiReferenceEntry(String tableName, String entityId, int multiReferencedColumnOneBasedOrdinalIndex, String referencedEntityId) {
        Consumer<IMutableNode> updateAction = d -> DataWriterActionProvider.deleteMultiReferenceEntry(d, tableName, entityId, multiReferencedColumnOneBasedOrdinalIndex, referencedEntityId);
        this.updaterCollector.addUpdater(updateAction);
    }

    public void deleteMultiValueEntry(String tableName, String entityId, int multiValueColumnOneBasedOrdinalIndex, String entry) {
        Consumer<IMutableNode> updateAction = d -> DataWriterActionProvider.deleteMultiValueEntry(d, tableName, entityId, multiValueColumnOneBasedOrdinalIndex, entry);
        this.updaterCollector.addUpdater(updateAction);
    }

    public void deleteEntity(String tableName, String entityId, String entitySaveStamp) {
        Consumer<IMutableNode> updateAction = d -> DataWriterActionProvider.deleteEntity(d, tableName, entityId, entitySaveStamp);
        this.updaterCollector.addUpdater(updateAction);
    }

    public void deleteMultiBackReferenceEntry(String tableName, String entityId, int multiBackReferenceColumnOneBasedOrdinalIndex, String backReferencedEntityId) {
        Consumer<IMutableNode> updateAction = d -> DataWriterActionProvider.deleteMultiBackReferenceEntry(d, tableName, entityId, multiBackReferenceColumnOneBasedOrdinalIndex, backReferencedEntityId);
        this.updaterCollector.addUpdater(updateAction);
    }

    public void expectSchemaTimestamp(ITime schemaTimestamp) {
        Consumer<IMutableNode> updateAction = d -> DataWriterActionProvider.expectSchemaTimestamp(d, schemaTimestamp);
        this.updaterCollector.addUpdater(updateAction);
    }

    public void expectTableContainsEntity(String tableName, String entityId) {
        Consumer<IMutableNode> updateAction = d -> DataWriterActionProvider.expectTableContainsEntity(d, tableName, entityId);
        this.updaterCollector.addUpdater(updateAction);
    }

    public int getSaveCount() {
        return this.saveCount;
    }

    public boolean hasUpdates() {
        return this.updaterCollector.containsAny();
    }

    public void insertEntity(String tableName, String entityId, INode<?> entityIndexNode, INode<?> entityNode) {
        Consumer<IMutableNode> updateAction = d -> DataWriterActionProvider.insertEntity(d, tableName, entityId, entityIndexNode, entityNode);
        this.updaterCollector.addUpdater(updateAction);
    }

    public void insertMultiBackReferenceEntry(String tableName, String entityId, int multiBackReferenceColumnOneBasedOrdinalIndex, INode<?> multiBackReferenceEntryNode) {
        Consumer<IMutableNode> updateAction = d -> DataWriterActionProvider.insertMultiBackReferenceEntry(d, tableName, entityId, multiBackReferenceColumnOneBasedOrdinalIndex, multiBackReferenceEntryNode);
        this.updaterCollector.addUpdater(updateAction);
    }

    public void insertMultiReferenceEntry(String tableName, String entityId, int multiReferenceColumnOneBasedOrdinalIndex, INode<?> multiReferenceEntryNode) {
        Consumer<IMutableNode> updateAction = d -> DataWriterActionProvider.insertMultiReferenceEntry(d, tableName, entityId, multiReferenceColumnOneBasedOrdinalIndex, multiReferenceEntryNode);
        this.updaterCollector.addUpdater(updateAction);
    }

    public void insertMultiValueEntry(String tableName, String entityId, int multiValueColumnOneBasedOrdinalIndex, String value) {
        Consumer<IMutableNode> updateAction = d -> DataWriterActionProvider.insertMultiValueEntry(d, tableName, entityId, multiValueColumnOneBasedOrdinalIndex, value);
        this.updaterCollector.addUpdater(updateAction);
    }

    public void reset() {
        this.updaterCollector.clear();
    }

    public void saveChangesAndReset() {
        try {
            MutableNode updatedNodeDatabase = MutableNode.fromNode(this.nodeDatabase);
            this.updaterCollector.updateObjectAndClear(updatedNodeDatabase);
            this.nodeDatabase.resetFromNode(updatedNodeDatabase);
            ++this.saveCount;
        }
        finally {
            this.reset();
        }
    }

    public void updateEntity(EntityUpdateDto entityUpdate, TableViewDto tableView) {
        Consumer<IMutableNode> updateAction = d -> DataWriterActionProvider.updateEntity(d, entityUpdate, tableView);
        this.updaterCollector.addUpdater(updateAction);
    }
}

