/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.nodemidschema.schemawriter;

import ch.nolix.core.document.node.MutableNode;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.resourcecontrol.closecontroller.CloseController;
import ch.nolix.coreapi.document.node.IMutableNode;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.coreapi.resourcecontrol.closecontroller.ICloseController;
import ch.nolix.system.nodemidschema.nodemapper.ColumnNodeMapper;
import ch.nolix.system.nodemidschema.nodemapper.ContentModelNodeMapper;
import ch.nolix.system.nodemidschema.nodemapper.TableNodeMapper;
import ch.nolix.system.nodemidschema.nodesearcher.ColumnNodeSearcher;
import ch.nolix.system.nodemidschema.nodesearcher.DatabaseNodeSearcher;
import ch.nolix.system.nodemidschema.nodesearcher.DatabasePropertiesNodeSearcher;
import ch.nolix.system.nodemidschema.nodesearcher.TableNodeSearcher;
import ch.nolix.system.time.moment.IncrementalCurrentTimeCreator;
import ch.nolix.systemapi.midschema.adapter.ISchemaWriter;
import ch.nolix.systemapi.midschema.model.ColumnDto;
import ch.nolix.systemapi.midschema.model.IContentModelDto;
import ch.nolix.systemapi.midschema.model.TableDto;
import ch.nolix.systemapi.nodemidschema.nodemapper.IColumnNodeMapper;
import ch.nolix.systemapi.nodemidschema.nodemapper.IContentModelNodeMapper;
import ch.nolix.systemapi.nodemidschema.nodemapper.ITableNodeMapper;
import ch.nolix.systemapi.nodemidschema.nodesearcher.IColumnNodeSearcher;
import ch.nolix.systemapi.nodemidschema.nodesearcher.IDatabaseNodeSearcher;
import ch.nolix.systemapi.nodemidschema.nodesearcher.IDatabasePropertiesNodeSearcher;
import ch.nolix.systemapi.nodemidschema.nodesearcher.ITableNodeSearcher;
import ch.nolix.systemapi.time.moment.IIncrementalCurrentTimeCreator;
import ch.nolix.systemapi.time.moment.ITime;

public final class SchemaWriter
implements ISchemaWriter {
    private static final IDatabaseNodeSearcher DATABASE_NODE_SEARCHER = new DatabaseNodeSearcher();
    private static final IDatabasePropertiesNodeSearcher DATABASE_PROPERTIES_NODE_SEARCHER = new DatabasePropertiesNodeSearcher();
    private static final ITableNodeSearcher TABLE_NODE_SEARCHER = new TableNodeSearcher();
    private static final IColumnNodeSearcher COLUMN_NODE_SEARCHER = new ColumnNodeSearcher();
    private static final ITableNodeMapper TABLE_NODE_MAPPER = new TableNodeMapper();
    private static final IColumnNodeMapper COLUMN_NODE_MAPPER = new ColumnNodeMapper();
    private static final IContentModelNodeMapper CONTENT_MODEL_NODE_MAPPER = new ContentModelNodeMapper();
    private static final IIncrementalCurrentTimeCreator INCREMENTAL_CURRENT_TIME_CREATOR = new IncrementalCurrentTimeCreator();
    private final ICloseController closeController = CloseController.forElement(this);
    private int saveCount;
    private final IMutableNode<?> nodeDatabase;
    private IMutableNode<?> editedNodeDatabase;
    private boolean hasChanges;

    private SchemaWriter(IMutableNode<?> nodeDatabase) {
        Validator.assertThat(nodeDatabase).thatIsNamed("database Node").isNotNull();
        this.nodeDatabase = nodeDatabase;
        this.reset();
    }

    public static SchemaWriter forNodeDatabase(IMutableNode<?> nodeDatabase) {
        return new SchemaWriter(nodeDatabase);
    }

    @Override
    public void addColumn(String tableName, ColumnDto column) {
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(this.editedNodeDatabase, tableName);
        tableNode.addChildNode(COLUMN_NODE_MAPPER.mapColumnDtoToColumnNode(column), new INode[0]);
        this.hasChanges = true;
    }

    @Override
    public void addTable(TableDto table) {
        this.editedNodeDatabase.addChildNode(TABLE_NODE_MAPPER.mapTableDtoToNode(table), new INode[0]);
        this.hasChanges = true;
    }

    @Override
    public void deleteColumn(String tableName, String columnName) {
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(this.editedNodeDatabase, tableName);
        tableNode.removeFirstChildNodeThat(a -> a.hasHeader("Column") && ((IMutableNode)COLUMN_NODE_SEARCHER.getStoredNameNodeFromColumnNode((IMutableNode)a).getStoredSingleChildNode()).hasHeader(columnName));
        this.hasChanges = true;
    }

    @Override
    public void deleteTable(String tableName) {
        this.editedNodeDatabase.removeFirstChildNodeThat(a -> a.hasHeader("Table") && ((IMutableNode)TABLE_NODE_SEARCHER.getStoredNameNodeFromTableNode((IMutableNode)a).getStoredSingleChildNode()).hasHeader(tableName));
        this.hasChanges = true;
    }

    @Override
    public ICloseController getStoredCloseController() {
        return this.closeController;
    }

    @Override
    public int getSaveCount() {
        return this.saveCount;
    }

    @Override
    public boolean hasChanges() {
        return this.hasChanges;
    }

    @Override
    public void noteClose() {
    }

    @Override
    public void reset() {
        this.editedNodeDatabase = MutableNode.fromNode(this.nodeDatabase);
        this.hasChanges = false;
    }

    @Override
    public void saveChanges() {
        try {
            this.setSchemaTimestamp(INCREMENTAL_CURRENT_TIME_CREATOR.getCurrentTime());
            this.nodeDatabase.setChildNodes(this.editedNodeDatabase.getStoredChildNodes());
            ++this.saveCount;
        }
        finally {
            this.reset();
        }
    }

    @Override
    public void renameColumn(String tableName, String columnName, String newColumnName) {
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(this.editedNodeDatabase, tableName);
        IMutableNode<?> columnNode = TABLE_NODE_SEARCHER.getStoredColumnNodeFromTableNodeByColumnName(tableNode, columnName);
        IMutableNode<?> headerNode = COLUMN_NODE_SEARCHER.getStoredNameNodeFromColumnNode(columnNode);
        headerNode.setHeader(newColumnName);
        this.hasChanges = true;
    }

    @Override
    public void setContentModel(String tableName, String columnName, IContentModelDto contentModel) {
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(this.nodeDatabase, tableName);
        IMutableNode<?> columnNode = TABLE_NODE_SEARCHER.getStoredColumnNodeFromTableNodeByColumnName(tableNode, columnName);
        columnNode.replaceFirstChildNodeWithGivenHeaderByGivenNode("ContentModel", CONTENT_MODEL_NODE_MAPPER.mapContentModelDtoToNode(contentModel));
        this.hasChanges = true;
    }

    @Override
    public void renameTable(String tableName, String newTableName) {
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(this.editedNodeDatabase, tableName);
        IMutableNode<?> nameNode = TABLE_NODE_SEARCHER.getStoredNameNodeFromTableNode(tableNode);
        ((IMutableNode)nameNode.getStoredSingleChildNode()).setHeader(newTableName);
        this.hasChanges = true;
    }

    private void setSchemaTimestamp(ITime schemaTimestamp) {
        IMutableNode<?> databasePropertiesNode = DATABASE_NODE_SEARCHER.getStoredDatabasePropertiesNodeFromNodeDatabase(this.editedNodeDatabase);
        IMutableNode<?> schemaTimestampNode = DATABASE_PROPERTIES_NODE_SEARCHER.getStoredSchemaTimestampNodeFromDatabasePropertiesNode(databasePropertiesNode);
        ((IMutableNode)schemaTimestampNode.getStoredSingleChildNode()).setHeader(schemaTimestamp.getSpecification().getSingleChildNodeHeader());
        this.hasChanges = true;
    }
}

