/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.changesetsaver;

import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.databaseobject.modelexaminer.DatabaseObjectExaminer;
import ch.nolix.system.objectdata.modelexaminer.EntityExaminer;
import ch.nolix.system.objectdata.modelsearcher.DatabaseSearcher;
import ch.nolix.systemapi.databaseobject.modelexaminer.IDatabaseObjectExaminer;
import ch.nolix.systemapi.middata.adapter.IDataAdapterAndSchemaReader;
import ch.nolix.systemapi.objectdata.model.IDatabase;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.model.IMultiReference;
import ch.nolix.systemapi.objectdata.model.IMultiReferenceEntry;
import ch.nolix.systemapi.objectdata.model.IOptionalReference;
import ch.nolix.systemapi.objectdata.model.IReference;
import ch.nolix.systemapi.objectdata.modelexaminer.IEntityExaminer;
import ch.nolix.systemapi.objectdata.modelsearcher.IDatabaseSearcher;

public final class ChangeSetSaveValidator {
    private static final IDatabaseObjectExaminer DATABASE_OBJECT_EXAMINER = new DatabaseObjectExaminer();
    private static final IDatabaseSearcher DATABASE_SEARCHER = new DatabaseSearcher();
    private static final IEntityExaminer ENTITY_EXAMINER = new EntityExaminer();

    public void addExpectationToDatabaseThatNewlyReferencedEntitiesExist(IDatabase database, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        IContainer<IEntity> entitiesInLocalData = DATABASE_SEARCHER.getStoredEntitiesInLocalData(database);
        for (IEntity e : entitiesInLocalData) {
            this.addExpectationToDatabaseThatNewlyReferencedEntitiesExist(e, dataAndSchemaAdapter);
        }
    }

    private void addExpectationToDatabaseThatNewlyReferencedEntitiesExist(IEntity entity, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        if (ENTITY_EXAMINER.isNewOrEdited(entity)) {
            this.addExpectationToDatabaseThatNewlyReferencedEntitiesExistWhenEntityIsNewOrEdited(entity, dataAndSchemaAdapter);
        }
    }

    private void addExpectationToDatabaseThatNewlyReferencedEntitiesExistWhenEntityIsNewOrEdited(IEntity entity, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        for (IField iField : entity.internalGetStoredFields()) {
            this.addExpectationToDatabaseThatNewlyReferencedEntitiesExist(iField, dataAndSchemaAdapter);
        }
    }

    private void addExpectationToDatabaseThatNewlyReferencedEntitiesExist(IField field, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        if (DATABASE_OBJECT_EXAMINER.isNewOrEdited(field)) {
            this.addExpectationToDatabaseThatNewlyReferencedEntitiesExistWhenFieldIsNewOrEdited(field, dataAndSchemaAdapter);
        }
    }

    private void addExpectationToDatabaseThatNewlyReferencedEntitiesExistWhenFieldIsNewOrEdited(IField field, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        switch (field.getType()) {
            case REFERENCE: {
                IReference reference = (IReference)field;
                this.addExpectationToDatabaseThatNewlyReferencedEntitiesExistWhenReferenceIsNewOrEdited(reference, dataAndSchemaAdapter);
                break;
            }
            case OPTIONAL_REFERENCE: {
                IOptionalReference optionalReference = (IOptionalReference)field;
                this.addExpectationToDatabaseThatNewlyReferencedEntitiesExistWhenOptionalReferenceIsNewOrEdited(optionalReference, dataAndSchemaAdapter);
                break;
            }
            case MULTI_REFERENCE: {
                IMultiReference multiReference = (IMultiReference)field;
                this.addExpectationToDatabaseThatNewlyReferencedEntitiesExistWhenMultiReferenceIsNewOrEdited(multiReference, dataAndSchemaAdapter);
            }
        }
    }

    private void addExpectationToDatabaseThatNewlyReferencedEntitiesExistWhenMultiReferenceIsNewOrEdited(IMultiReference<?> multiReference, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        String referencedTableName = multiReference.getReferencedTableName();
        for (IMultiReferenceEntry iMultiReferenceEntry : multiReference.getStoredNewAndDeletedEntries()) {
            if (!iMultiReferenceEntry.isNew()) continue;
            dataAndSchemaAdapter.expectTableContainsEntity(referencedTableName, iMultiReferenceEntry.getReferencedEntityId());
        }
    }

    private void addExpectationToDatabaseThatNewlyReferencedEntitiesExistWhenOptionalReferenceIsNewOrEdited(IOptionalReference<?> optionalReference, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        if (optionalReference.containsAny()) {
            dataAndSchemaAdapter.expectTableContainsEntity(optionalReference.getReferencedTableName(), optionalReference.getReferencedEntityId());
        }
    }

    private void addExpectationToDatabaseThatNewlyReferencedEntitiesExistWhenReferenceIsNewOrEdited(IReference<?> reference, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        dataAndSchemaAdapter.expectTableContainsEntity(reference.getReferencedTableName(), reference.getReferencedEntityId());
    }
}

