/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.changesetsaver;

import ch.nolix.system.databaseobject.modelexaminer.DatabaseObjectExaminer;
import ch.nolix.system.objectdata.changesetsaver.MultiBackReferenceSaver;
import ch.nolix.system.objectdata.changesetsaver.MultiReferenceSaver;
import ch.nolix.system.objectdata.changesetsaver.MultiValueSaver;
import ch.nolix.system.objectdata.middatamodelmapper.EntityDtoMapper;
import ch.nolix.systemapi.databaseobject.modelexaminer.IDatabaseObjectExaminer;
import ch.nolix.systemapi.databaseobject.property.DatabaseObjectState;
import ch.nolix.systemapi.middata.adapter.IDataAdapterAndSchemaReader;
import ch.nolix.systemapi.objectdata.middatamodelmapper.IEntityDtoMapper;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.model.IMultiBackReference;
import ch.nolix.systemapi.objectdata.model.IMultiReference;
import ch.nolix.systemapi.objectdata.model.IMultiValueField;
import ch.nolix.systemapi.objectdata.model.ITable;

public final class EntitySaver {
    private static final IDatabaseObjectExaminer DATABASE_OBJECT_EXAMINER = new DatabaseObjectExaminer();
    private static final IEntityDtoMapper ENTITY_DTO_MAPPER = new EntityDtoMapper();
    private static final MultiValueSaver MULTI_VALUE_SAVER = new MultiValueSaver();
    private static final MultiReferenceSaver MULTI_REFERENCE_SAVER = new MultiReferenceSaver();
    private static final MultiBackReferenceSaver MULTI_BACK_REFERENCE_SAVER = new MultiBackReferenceSaver();

    public void saveChangesOfEntity(IEntity entity, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        switch ((DatabaseObjectState)((Object)entity.getState())) {
            case NEW: {
                this.saveNewEntity(entity, dataAndSchemaAdapter);
                break;
            }
            case EDITED: {
                this.saveChangesOfEditedEntity(entity, dataAndSchemaAdapter);
                break;
            }
            case DELETED: {
                this.saveEntityDeletion(entity, dataAndSchemaAdapter);
            }
        }
    }

    private void saveNewEntity(IEntity newEntity, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        dataAndSchemaAdapter.insertEntity(((ITable)newEntity.getStoredParentTable()).getName(), ENTITY_DTO_MAPPER.mapEntityToEntityCreationDto(newEntity));
        this.saveMultiPropertyChangesOfEntity(newEntity, dataAndSchemaAdapter);
    }

    private void saveChangesOfEditedEntity(IEntity editedEntity, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        dataAndSchemaAdapter.updateEntity(((ITable)editedEntity.getStoredParentTable()).getName(), ENTITY_DTO_MAPPER.mapEntityToEntityUpdateDto(editedEntity));
        this.saveMultiPropertyChangesOfEntity(editedEntity, dataAndSchemaAdapter);
    }

    private void saveEntityDeletion(IEntity deletedEntity, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        dataAndSchemaAdapter.deleteEntity(((ITable)deletedEntity.getStoredParentTable()).getName(), ENTITY_DTO_MAPPER.mapEntityToEntityDeletionDto(deletedEntity));
    }

    private void saveMultiPropertyChangesOfEntity(IEntity entity, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        for (IField iField : entity.internalGetStoredFields()) {
            this.saveChangesOfPotentialMultiProperty(iField, dataAndSchemaAdapter);
        }
    }

    private void saveChangesOfPotentialMultiProperty(IField p, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        if (DATABASE_OBJECT_EXAMINER.isNewOrEdited(p)) {
            this.saveChangesOfPotentialMultiPropertyWhenIsNewOrEdited(p, dataAndSchemaAdapter);
        }
    }

    private void saveChangesOfPotentialMultiPropertyWhenIsNewOrEdited(IField field, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        switch (field.getType()) {
            case MULTI_VALUE_FIELD: {
                MULTI_VALUE_SAVER.saveChangesOfMultiValue((IMultiValueField)field, dataAndSchemaAdapter);
                break;
            }
            case MULTI_REFERENCE: {
                MULTI_REFERENCE_SAVER.saveMultiReference((IMultiReference)field, dataAndSchemaAdapter);
                break;
            }
            case MULTI_BACK_REFERENCE: {
                MULTI_BACK_REFERENCE_SAVER.saveMultiBackReference((IMultiBackReference)field, dataAndSchemaAdapter);
            }
        }
    }
}

