/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.model.AbstractField;
import ch.nolix.system.objectdata.model.BackReference;
import ch.nolix.system.objectdata.model.OptionalBackReference;
import ch.nolix.system.objectdata.model.Table;
import ch.nolix.systemapi.objectdata.model.IBaseReference;
import ch.nolix.systemapi.objectdata.model.IDatabase;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.model.ITable;

public abstract class AbstractBaseReference<E extends IEntity>
extends AbstractField
implements IBaseReference<E> {
    private final ImmutableList<String> referenceableTableNames;
    private final String referencedTableName;
    private Table<E> referencedTable;

    protected AbstractBaseReference(IContainer<String> referenceableTableNames) {
        Validator.assertThatTheStrings(referenceableTableNames).areNotBlank();
        this.referenceableTableNames = ImmutableList.forIterable(referenceableTableNames);
        this.referencedTableName = (String)referenceableTableNames.getStoredFirst();
    }

    protected AbstractBaseReference(String referencedTableName) {
        Validator.assertThat(referencedTableName).thatIsNamed("referenced table name").isNotBlank();
        this.referenceableTableNames = null;
        this.referencedTableName = referencedTableName;
    }

    @Override
    public final IContainer<String> getReferenceableTableNames() {
        return this.referenceableTableNames;
    }

    @Override
    public String getReferencedTableId() {
        return this.getStoredReferencedTable().getId();
    }

    @Override
    public String getReferencedTableName() {
        return this.referencedTableName;
    }

    @Override
    public final IContainer<IBaseReference<IEntity>> getStoredBaseReferencesWhoAreBackReferencedFromThis() {
        return ImmutableList.createEmpty();
    }

    @Override
    public ITable<E> getStoredReferencedTable() {
        this.extractReferencedTableIfNotExtracted();
        return this.referencedTable;
    }

    @Override
    public final boolean referencesBackEntity(IEntity entity) {
        return false;
    }

    @Override
    public final boolean referencesBackEntityWithId(String id) {
        return false;
    }

    @Override
    public final boolean referencesBackField(IField field) {
        return false;
    }

    protected final void updateProbableBackReferenceForSetOrAddedEntity(E entity) {
        for (IField iField : entity.internalGetStoredFields()) {
            switch (iField.getType()) {
                case BACK_REFERENCE: {
                    BackReference backReference = (BackReference)iField;
                    if (!backReference.referencesBackField(this)) break;
                    backReference.internalSetDirectlyBackReferencedEntityId(this.getStoredParentEntity().getId());
                    break;
                }
                case OPTIONAL_BACK_REFERENCE: {
                    OptionalBackReference optionalBackReference = (OptionalBackReference)iField;
                    if (!optionalBackReference.referencesBackField(this)) break;
                    optionalBackReference.internalSetDirectlyBackReferencedEntityId(this.getStoredParentEntity().getId());
                }
            }
        }
    }

    private boolean extractedReferencedTable() {
        return this.referencedTable != null;
    }

    private void extractReferencedTable() {
        this.referencedTable = this.loadReferencedTable();
    }

    private void extractReferencedTableIfNotExtracted() {
        if (!this.extractedReferencedTable()) {
            this.extractReferencedTable();
        }
    }

    private Table<E> loadReferencedTable() {
        return (Table)((IDatabase)this.getStoredParentEntity().getStoredParentTable().getStoredParentDatabase()).getStoredTableByName(this.getReferencedTableName());
    }
}

