/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.system.objectdata.model.BackReference;
import ch.nolix.system.objectdata.model.OptionalBackReference;
import ch.nolix.systemapi.objectdata.model.IBaseBackReference;
import ch.nolix.systemapi.objectdata.model.IEntity;

public final class BaseBackReferenceUpdater {
    private BaseBackReferenceUpdater() {
    }

    public static void updateBaseBackReferenceForClearBaseReference(IBaseBackReference<IEntity> baseBackReferene) {
        switch (baseBackReferene.getType()) {
            case BACK_REFERENCE: {
                BackReference backReference = (BackReference)baseBackReferene;
                backReference.internalClear();
                backReference.setAsEditedAndRunPotentialUpdateAction();
                break;
            }
            case OPTIONAL_BACK_REFERENCE: {
                OptionalBackReference optionalBackReference = (OptionalBackReference)baseBackReferene;
                optionalBackReference.internalClear();
                optionalBackReference.setAsEditedAndRunPotentialUpdateAction();
                break;
            }
            case MULTI_BACK_REFERENCE: {
                break;
            }
            default: {
                throw InvalidArgumentException.forArgumentAndArgumentName(baseBackReferene, "back referencing field");
            }
        }
    }
}

