/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.model.ColumnMapper;
import ch.nolix.system.objectdata.model.Database;
import ch.nolix.system.objectdata.model.Table;
import ch.nolix.system.objectdata.model.TableMapper;
import ch.nolix.systemapi.midschema.fieldproperty.BaseFieldType;
import ch.nolix.systemapi.midschema.model.ColumnDto;
import ch.nolix.systemapi.midschema.model.TableDto;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.ITable;
import ch.nolix.systemapi.objectdata.schemaview.IColumnView;

final class DatabaseTableLoader {
    private static final TableMapper TABLE_MAPPER = new TableMapper();
    private static final ColumnMapper COLUMN_MAPPER = new ColumnMapper();

    DatabaseTableLoader() {
    }

    public LinkedList<Table<IEntity>> loadTablesForDatabase(Database database) {
        IContainer<TableDto> midTables = database.getStoredMidDataAdapterAndSchemaReader().loadTables();
        IContainer<Table<IEntity>> tables = midTables.to(rt -> TABLE_MAPPER.mapTableDtoToTableWithoutColumnsAndWithoutEntities((TableDto)rt, database));
        this.addBaseValueColumnsToTablesFromMidTables(tables, midTables);
        this.addBaseReferenceColumnsToTablesFromMidTables(tables, midTables, tables);
        this.addBaseBackReferenceColumnsToTablesFromMidTables(tables, midTables, tables);
        return LinkedList.fromIterable(tables);
    }

    private void addBaseValueColumnsToTablesFromMidTables(IContainer<Table<IEntity>> tables, IContainer<TableDto> midTables) {
        for (Table table : tables) {
            String tableName = table.getName();
            TableDto midTable = midTables.getStoredFirst(rt -> rt.name().equals(tableName));
            this.addBaseValueColumnsToTableFromMidTable(table, midTable);
        }
    }

    private void addBaseValueColumnsToTableFromMidTable(Table<IEntity> table, TableDto midTable) {
        IContainer<ColumnDto> midBaseValueColumns = midTable.columns().getStoredSelected(this::isBaseValue);
        for (ColumnDto c : midBaseValueColumns) {
            IColumnView<ITable<IEntity>> column = COLUMN_MAPPER.mapMidSchemaColumnDtoToColumnView(c, table, ImmutableList.createEmpty());
            table.internalAddColumn(column);
        }
    }

    private void addBaseReferenceColumnsToTablesFromMidTables(IContainer<Table<IEntity>> tables, IContainer<TableDto> midTables, IContainer<? extends ITable<IEntity>> referencableTables) {
        for (Table table : tables) {
            String tableName = table.getName();
            TableDto midTable = midTables.getStoredFirst(rt -> rt.name().equals(tableName));
            this.addBaseReferenceColumnsToTableFromMidTable(table, midTable, referencableTables);
        }
    }

    private void addBaseReferenceColumnsToTableFromMidTable(Table<IEntity> table, TableDto midTable, IContainer<? extends ITable<IEntity>> referencableTables) {
        IContainer<ColumnDto> midBaseReferenceColumns = midTable.columns().getStoredSelected(this::isBaseReference);
        for (ColumnDto c : midBaseReferenceColumns) {
            IColumnView<ITable<IEntity>> column = COLUMN_MAPPER.mapMidSchemaColumnDtoToColumnView(c, table, referencableTables);
            table.internalAddColumn(column);
        }
    }

    private void addBaseBackReferenceColumnsToTablesFromMidTables(IContainer<Table<IEntity>> tables, IContainer<TableDto> midTables, IContainer<? extends ITable<IEntity>> referencableTables) {
        for (Table table : tables) {
            String tableName = table.getName();
            TableDto midTable = midTables.getStoredFirst(rt -> rt.name().equals(tableName));
            this.addBaseBackReferenceColumnsToTableFromMidTable(table, midTable, referencableTables);
        }
    }

    private void addBaseBackReferenceColumnsToTableFromMidTable(Table<IEntity> table, TableDto midTable, IContainer<? extends ITable<IEntity>> referencableTables) {
        IContainer<ColumnDto> midBaseValueColumns = midTable.columns().getStoredSelected(this::isBaseBackReference);
        for (ColumnDto c : midBaseValueColumns) {
            IColumnView<ITable<IEntity>> column = COLUMN_MAPPER.mapMidSchemaColumnDtoToColumnView(c, table, referencableTables);
            table.internalAddColumn(column);
        }
    }

    private boolean isBaseBackReference(ColumnDto columnDto) {
        return columnDto.contentModel().getFieldType().getBaseType() == BaseFieldType.BASE_BACK_REFERENCE;
    }

    private boolean isBaseReference(ColumnDto columnDto) {
        return columnDto.contentModel().getFieldType().getBaseType() == BaseFieldType.BASE_REFERENCE;
    }

    private boolean isBaseValue(ColumnDto columnDto) {
        return columnDto.contentModel().getFieldType().getBaseType() == BaseFieldType.BASE_VALUE_FIELD;
    }
}

