/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.coreapi.attribute.mandatoryattribute.INameHolder;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.model.AbstractEntity;
import ch.nolix.system.objectdata.model.AbstractField;
import ch.nolix.system.objectdata.model.BackReference;
import ch.nolix.system.objectdata.model.MultiBackReference;
import ch.nolix.system.objectdata.model.MultiReference;
import ch.nolix.system.objectdata.model.MultiValueField;
import ch.nolix.system.objectdata.model.OptionalBackReference;
import ch.nolix.system.objectdata.model.OptionalReference;
import ch.nolix.system.objectdata.model.OptionalValueField;
import ch.nolix.system.objectdata.model.Reference;
import ch.nolix.system.objectdata.model.ValueField;
import ch.nolix.systemapi.midschema.fieldproperty.FieldType;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.ITable;
import ch.nolix.systemapi.objectdata.schemaview.IBaseBackReferenceModelView;
import ch.nolix.systemapi.objectdata.schemaview.IBaseReferenceModelView;
import ch.nolix.systemapi.objectdata.schemaview.IBaseValueModelView;
import ch.nolix.systemapi.objectdata.schemaview.IColumnView;
import ch.nolix.systemapi.objectdata.schemaview.IContentModelView;

public final class FieldFromColumnCreator {
    private FieldFromColumnCreator() {
    }

    public static AbstractField createFieldFromAndWithColumnView(IColumnView<ITable<IEntity>> columnView) {
        AbstractField field = FieldFromColumnCreator.createFieldFromColumnView(columnView);
        field.setParentColumn(columnView);
        return field;
    }

    private static AbstractField createFieldFromColumnView(IColumnView<ITable<IEntity>> columnView) {
        IContentModelView<ITable<IEntity>> contentModelView = columnView.getContentModel();
        return FieldFromColumnCreator.createFieldFromContentModelView(contentModelView);
    }

    private static AbstractField createFieldFromContentModelView(IContentModelView<ITable<IEntity>> contentModelView) {
        FieldType fieldType = contentModelView.getFieldType();
        return switch (fieldType) {
            case FieldType.VALUE_FIELD -> ValueField.withValueType(((IBaseValueModelView)contentModelView).getValueType());
            case FieldType.OPTIONAL_VALUE_FIELD -> OptionalValueField.withValueType(((IBaseValueModelView)contentModelView).getValueType());
            case FieldType.MULTI_VALUE_FIELD -> MultiValueField.withValueType(((IBaseValueModelView)contentModelView).getValueType());
            case FieldType.REFERENCE -> FieldFromColumnCreator.createReferenceFromAbstractReferenceModelView((IBaseReferenceModelView)contentModelView);
            case FieldType.OPTIONAL_REFERENCE -> FieldFromColumnCreator.createOptionalReferenceFromAbstractReferenceModelView((IBaseReferenceModelView)contentModelView);
            case FieldType.MULTI_REFERENCE -> FieldFromColumnCreator.createMultiReferenceFromAbstractReferenceModelView((IBaseReferenceModelView)contentModelView);
            case FieldType.BACK_REFERENCE -> FieldFromColumnCreator.createBackReferenceFromAbstractBackReferenceModelView((IBaseBackReferenceModelView)contentModelView);
            case FieldType.OPTIONAL_BACK_REFERENCE -> FieldFromColumnCreator.createOptionalBackReferenceFromAbstractBackReferenceModelView((IBaseBackReferenceModelView)contentModelView);
            case FieldType.MULTI_BACK_REFERENCE -> FieldFromColumnCreator.createMultiBackReferenceFromAbstractBackReferenceModelView((IBaseBackReferenceModelView)contentModelView);
            default -> throw new MatchException(null, null);
        };
    }

    private static Reference<AbstractEntity> createReferenceFromAbstractReferenceModelView(IBaseReferenceModelView<ITable<IEntity>> abstractReferenceModelView) {
        IContainer<String> referenceableTableNames = abstractReferenceModelView.getStoredReferenceableTables().to(INameHolder::getName);
        return Reference.forReferenceableTableNames(referenceableTableNames);
    }

    private static OptionalReference<AbstractEntity> createOptionalReferenceFromAbstractReferenceModelView(IBaseReferenceModelView<ITable<IEntity>> abstractReferenceModelView) {
        IContainer<String> referenceableTableNames = abstractReferenceModelView.getStoredReferenceableTables().to(INameHolder::getName);
        return OptionalReference.forReferenceableTableNames(referenceableTableNames);
    }

    private static MultiReference<AbstractEntity> createMultiReferenceFromAbstractReferenceModelView(IBaseReferenceModelView<ITable<IEntity>> abstractReferenceModelView) {
        IContainer<String> referenceableTableNames = abstractReferenceModelView.getStoredReferenceableTables().to(INameHolder::getName);
        return MultiReference.forReferenceableTableNames(referenceableTableNames);
    }

    private static BackReference<AbstractEntity> createBackReferenceFromAbstractBackReferenceModelView(IBaseBackReferenceModelView<IColumnView<ITable<IEntity>>, ITable<IEntity>> abstractBackReferenceModelView) {
        IColumnView<ITable<IEntity>> backReferencedColumn = abstractBackReferenceModelView.getBackReferencedColumn();
        ITable<IEntity> backReferencedTable = backReferencedColumn.getStoredParentTable();
        String backReferencedTableName = backReferencedTable.getName();
        String backReferencedFieldName = backReferencedColumn.getName();
        return BackReference.forEntityWithTableNameAndBackReferencedFieldName(backReferencedTableName, backReferencedFieldName);
    }

    private static OptionalBackReference<AbstractEntity> createOptionalBackReferenceFromAbstractBackReferenceModelView(IBaseBackReferenceModelView<IColumnView<ITable<IEntity>>, ITable<IEntity>> abstractBackReferenceModelView) {
        IColumnView<ITable<IEntity>> backReferencedColumn = abstractBackReferenceModelView.getBackReferencedColumn();
        ITable<IEntity> backReferencedTable = backReferencedColumn.getStoredParentTable();
        String backReferencedTableName = backReferencedTable.getName();
        String backReferencedFieldName = backReferencedColumn.getName();
        return OptionalBackReference.forEntityWithTableNameAndBackReferencedFieldName(backReferencedTableName, backReferencedFieldName);
    }

    private static MultiBackReference<AbstractEntity> createMultiBackReferenceFromAbstractBackReferenceModelView(IBaseBackReferenceModelView<IColumnView<ITable<IEntity>>, ITable<IEntity>> abstractBackReferenceModelView) {
        IColumnView<ITable<IEntity>> backReferencedColumn = abstractBackReferenceModelView.getBackReferencedColumn();
        ITable<IEntity> backReferencedTable = backReferencedColumn.getStoredParentTable();
        String backReferencedTableName = backReferencedTable.getName();
        String backReferencedFieldName = backReferencedColumn.getName();
        return MultiBackReference.forBackReferencedTableAndBaseReference(backReferencedTableName, backReferencedFieldName);
    }
}

