/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.system.databaseobject.modelvalidator.DatabaseObjectValidator;
import ch.nolix.systemapi.databaseobject.property.DatabaseObjectState;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.model.IMultiReference;
import ch.nolix.systemapi.objectdata.model.IMultiReferenceEntry;
import java.util.Optional;

final class MultiReferenceEntry<E extends IEntity>
implements IMultiReferenceEntry<E> {
    private static final DatabaseObjectValidator DATABASE_OBJECT_VALIDATOR = new DatabaseObjectValidator();
    private final IMultiReference<E> parentMultiReference;
    private DatabaseObjectState state;
    private final String referencedEntityId;
    private String referencedTableId;

    private MultiReferenceEntry(IMultiReference<E> parentMultiReference, DatabaseObjectState initialState, String referencedEntityId) {
        Validator.assertThat(parentMultiReference).thatIsNamed("parent MultiReference").isNotNull();
        Validator.assertThat(initialState).thatIsNamed("initial state").isNotNull();
        Validator.assertThat(referencedEntityId).thatIsNamed("referenced entity id").isNotBlank();
        this.parentMultiReference = parentMultiReference;
        this.state = initialState;
        this.referencedEntityId = referencedEntityId;
    }

    private MultiReferenceEntry(IMultiReference<E> parentMultiReference, DatabaseObjectState initialState, String referencedEntityId, String referencedEntityTableId) {
        Validator.assertThat(parentMultiReference).thatIsNamed("parent MultiReference").isNotNull();
        Validator.assertThat(initialState).thatIsNamed("initial state").isNotNull();
        Validator.assertThat(referencedEntityId).thatIsNamed("referenced entity id").isNotBlank();
        Validator.assertThat(referencedEntityTableId).thatIsNamed("referenced entity table id").isNotBlank();
        this.parentMultiReference = parentMultiReference;
        this.state = initialState;
        this.referencedEntityId = referencedEntityId;
        this.referencedTableId = referencedEntityId;
    }

    public static <E2 extends IEntity> MultiReferenceEntry<E2> createLoadedEntryForMultiReferenceAndReferencedEntityIdAndReferencedTableId(IMultiReference<E2> multiReference, String referencedEntityId, String referencedEntityTableId) {
        return new MultiReferenceEntry<E2>(multiReference, DatabaseObjectState.UNEDITED, referencedEntityId, referencedEntityTableId);
    }

    public static <E2 extends IEntity> MultiReferenceEntry<E2> createNewEntryForMultiReferenceAndReferencedEntityId(IMultiReference<E2> multiReference, String referencedEntityId) {
        return new MultiReferenceEntry<E2>(multiReference, DatabaseObjectState.NEW, referencedEntityId);
    }

    public static <E2 extends IEntity> MultiReferenceEntry<E2> createNewEntryForMultiReferenceAndReferencedEntityIdAndReferencedTableId(IMultiReference<E2> multiReference, String referencedEntityId, String referencedTableId) {
        return new MultiReferenceEntry<E2>(multiReference, DatabaseObjectState.NEW, referencedEntityId, referencedTableId);
    }

    @Override
    public Optional<? extends IField> getOptionalStoredBaseBackReferenceWhoReferencesBackTheParentMultiReferenceOfThis() {
        return this.getStoredReferencedEntity().internalGetStoredFields().getOptionalStoredFirst(p -> p.referencesBackField(this.getStoredParentMultiReference()));
    }

    @Override
    public String getReferencedTableId() {
        this.assertKnowsReferencedTable();
        return this.referencedTableId;
    }

    @Override
    public IMultiReference<E> getStoredParentMultiReference() {
        return this.parentMultiReference;
    }

    @Override
    public DatabaseObjectState getState() {
        return switch ((DatabaseObjectState)((Object)this.getStoredParentMultiReference().getState())) {
            case DatabaseObjectState.NEW -> DatabaseObjectState.NEW;
            case DatabaseObjectState.DELETED -> DatabaseObjectState.DELETED;
            case DatabaseObjectState.CLOSED -> DatabaseObjectState.CLOSED;
            default -> this.state;
        };
    }

    @Override
    public String getReferencedEntityId() {
        return this.referencedEntityId;
    }

    @Override
    public E getStoredReferencedEntity() {
        return this.getStoredParentMultiReference().getStoredReferencedTable().getStoredEntityById(this.getReferencedEntityId());
    }

    @Override
    public boolean isClosed() {
        return this.getStoredParentMultiReference().isClosed();
    }

    @Override
    public boolean isDeleted() {
        return this.getStoredParentMultiReference().isDeleted();
    }

    @Override
    public boolean isEdited() {
        return false;
    }

    @Override
    public boolean isConnectedWithRealDatabase() {
        return this.getStoredParentMultiReference().isConnectedWithRealDatabase();
    }

    @Override
    public boolean isLoaded() {
        return this.getState() == DatabaseObjectState.UNEDITED;
    }

    @Override
    public boolean isNew() {
        return this.getState() == DatabaseObjectState.NEW;
    }

    @Override
    public boolean knowsReferencedTable() {
        return this.referencedTableId != null;
    }

    void setDeleted() {
        this.assertIsLoaded();
        this.state = DatabaseObjectState.DELETED;
    }

    private void assertKnowsReferencedTable() {
        if (!this.knowsReferencedTable()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "does not know its referenced table");
        }
    }

    private void assertIsLoaded() {
        DATABASE_OBJECT_VALIDATOR.assertIsLoaded(this);
    }
}

