/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.entitytool.TableNameExtractor;
import ch.nolix.system.objectdata.fieldtool.OptionalReferenceTool;
import ch.nolix.system.objectdata.fieldvalidator.OptionalReferenceValidator;
import ch.nolix.system.objectdata.model.AbstractBaseReference;
import ch.nolix.system.objectdata.model.BaseBackReferenceUpdater;
import ch.nolix.system.objectdata.model.BaseReferenceUpdater;
import ch.nolix.system.objectdata.modelsearcher.EntitySearcher;
import ch.nolix.systemapi.databaseobject.property.DatabaseObjectState;
import ch.nolix.systemapi.midschema.fieldproperty.FieldType;
import ch.nolix.systemapi.objectdata.entitytool.ITableNameExtractor;
import ch.nolix.systemapi.objectdata.fieldtool.IOptionalReferenceTool;
import ch.nolix.systemapi.objectdata.fieldvalidator.IOptionalReferenceValidator;
import ch.nolix.systemapi.objectdata.model.IBaseBackReference;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.model.IOptionalReference;
import ch.nolix.systemapi.objectdata.modelsearcher.IEntitySearcher;
import java.util.Optional;

public final class OptionalReference<E extends IEntity>
extends AbstractBaseReference<E>
implements IOptionalReference<E> {
    private static final ITableNameExtractor TABLE_NAME_EXTRACTOR = new TableNameExtractor();
    private static final IEntitySearcher ENTITY_SEARCHER = new EntitySearcher();
    private static final IOptionalReferenceValidator OPTIONAL_REFERENCE_VALIDATOR = new OptionalReferenceValidator();
    private static final IOptionalReferenceTool OPTIONAL_REFERENCE_TOOL = new OptionalReferenceTool();
    private String referencedEntityId;

    private OptionalReference(IContainer<String> referenceableTableNames) {
        super(referenceableTableNames);
    }

    @SafeVarargs
    public static <E2 extends IEntity> OptionalReference<E2> forEntityType(Class<? extends E2> entity, Class<? extends E2> ... entityTypes) {
        ContainerView<Class<String>> allEntityTypes = ContainerView.forElementAndArray(entity, entityTypes);
        IContainer<String> referenceableTableNames = allEntityTypes.to(TABLE_NAME_EXTRACTOR::getTableNameOfEntityType);
        return new OptionalReference(referenceableTableNames);
    }

    public static <E2 extends IEntity> OptionalReference<E2> forReferenceableTableName(String referenceableTableName, String ... referenceableTableNames) {
        ContainerView<String> allReferenceableTableNames = ContainerView.forElementAndArray(referenceableTableName, referenceableTableNames);
        return new OptionalReference(allReferenceableTableNames);
    }

    public static <E2 extends IEntity> OptionalReference<E2> forReferenceableTableNames(IContainer<String> referenceableTableNames) {
        return new OptionalReference(referenceableTableNames);
    }

    @Override
    public void clear() {
        if (this.containsAny()) {
            this.clearWhenContainsAny();
        }
    }

    @Override
    public String getReferencedEntityId() {
        OPTIONAL_REFERENCE_VALIDATOR.assertIsNotEmpty(this);
        return this.referencedEntityId;
    }

    @Override
    public IContainer<IBaseBackReference<IEntity>> getStoredBaseBackReferencesWhoReferencesBackThis() {
        if (this.isEmpty()) {
            return ImmutableList.createEmpty();
        }
        IContainer<? extends IField> fields = this.getStoredReferencedEntity().internalGetStoredFields();
        Optional<IField> abstractBackReferenceContainer = fields.getOptionalStoredFirst(f -> f.referencesBackField(this));
        if (abstractBackReferenceContainer.isPresent()) {
            IBaseBackReference abstractBackReference = (IBaseBackReference)abstractBackReferenceContainer.get();
            return ImmutableList.withElement(abstractBackReference, new IBaseBackReference[0]);
        }
        return ImmutableList.createEmpty();
    }

    @Override
    public E getStoredReferencedEntity() {
        return this.getStoredReferencedTable().getStoredEntityById(this.getReferencedEntityId());
    }

    @Override
    public FieldType getType() {
        return FieldType.OPTIONAL_REFERENCE;
    }

    @Override
    public void internalSetNullableValue(Object nullableValue, String nullableAdditionalValue) {
        this.referencedEntityId = (String)nullableValue;
    }

    @Override
    public boolean isEmpty() {
        return this.referencedEntityId == null;
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public boolean referencesEntity(IEntity entity) {
        return this.containsAny() && entity != null && this.getReferencedEntityId().equals(entity.getId());
    }

    @Override
    public boolean referencesUninsertedEntity() {
        return this.containsAny() && !this.getStoredReferencedEntity().belongsToTable();
    }

    @Override
    public void setEntity(Object entity) {
        this.setCastedEntity((IEntity)entity);
    }

    @Override
    public void setEntityById(String id) {
        Object entity = this.getStoredReferencedTable().getStoredEntityById(id);
        this.setEntity(entity);
    }

    @Override
    protected void noteInsertIntoDatabase() {
        if (this.containsAny()) {
            this.updateProbableBackReferenceForSetOrAddedEntity(this.getStoredReferencedEntity());
        }
    }

    private void assertCanClear() {
        OPTIONAL_REFERENCE_VALIDATOR.assertCanClear(this);
    }

    private void assertCanSetEntity(E entity) {
        OPTIONAL_REFERENCE_VALIDATOR.assertCanSetGivenEntity(this, entity);
    }

    private void clearWhenContainsAny() {
        this.assertCanClear();
        this.updateProbableBackReferencingFieldForClear();
        this.updateStateForClear();
        this.setAsEditedAndRunPotentialUpdateAction();
    }

    private Optional<? extends IField> getOptionalPendantReferencingFieldToEntity(E entity) {
        return ENTITY_SEARCHER.getStoredFieldsWhoAreBackReferencedFromEntity((IEntity)entity).getOptionalStoredFirst(f -> f.hasName(this.getName()));
    }

    private void insertEntityIntoDatabaseIfPossible(E entity) {
        if (this.belongsToEntity() && this.getStoredParentEntity().belongsToTable() && entity.getState() == DatabaseObjectState.NEW && !entity.belongsToTable()) {
            this.getStoredParentEntity().getStoredParentDatabase().insertEntity(entity);
        }
    }

    private void setCastedEntity(E entity) {
        this.assertCanSetEntity(entity);
        this.updatePropbableBackReferencingFieldOfEntityForClear(entity);
        this.clear();
        this.updateStateForSetEntity(entity);
        this.updatePotentialBaseBackReferenceOfEntityForSetEntity(entity);
        this.insertEntityIntoDatabaseIfPossible(entity);
        this.setAsEditedAndRunPotentialUpdateAction();
    }

    private void updatePotentialBaseBackReferenceOfEntityForSetEntity(E entity) {
        BaseReferenceUpdater.ofBaseReferenceUpdatePotentialBaseBackReferenceForAddOrSetEntity(this, entity);
    }

    private void updateProbableBackReferencingFieldForClear() {
        if (this.containsAny()) {
            this.updateProbableBackReferencingFieldForClearWhenIsNotEmpty();
        }
    }

    private void updateProbableBackReferencingFieldForClearWhenIsNotEmpty() {
        Optional<IBaseBackReference<IEntity>> backReferencingField = OPTIONAL_REFERENCE_TOOL.getOptionalStoredBaseBackReference(this);
        if (backReferencingField.isPresent()) {
            BaseBackReferenceUpdater.updateBaseBackReferenceForClearBaseReference(backReferencingField.get());
        }
    }

    private void updatePropbableBackReferencingFieldOfEntityForClear(E entity) {
        Optional<IField> pendantReferencingField = this.getOptionalPendantReferencingFieldToEntity(entity);
        if (pendantReferencingField.isPresent()) {
            OptionalReference reference = (OptionalReference)pendantReferencingField.get();
            reference.clear();
        }
    }

    private void updateStateForSetEntity(E entity) {
        this.referencedEntityId = entity.getId();
    }

    private void updateStateForClear() {
        this.referencedEntityId = null;
    }
}

