/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.datamodel.fliedvalue.ValueMapper;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.datamodel.fieldproperty.DataType;
import ch.nolix.coreapi.datamodel.fieldvalue.IValueMapper;
import ch.nolix.system.objectdata.fieldvalidator.OptionalValueValidator;
import ch.nolix.system.objectdata.model.AbstractBaseValueField;
import ch.nolix.systemapi.midschema.fieldproperty.FieldType;
import ch.nolix.systemapi.objectdata.fieldvalidator.IOptionalValueValidator;
import ch.nolix.systemapi.objectdata.model.IOptionalValueField;

public final class OptionalValueField<V>
extends AbstractBaseValueField<V>
implements IOptionalValueField<V> {
    private static final IOptionalValueValidator OPTIONAL_VALUE_VALIDATOR = new OptionalValueValidator();
    private static final IValueMapper VALUE_MAPPER = new ValueMapper();
    private V internalValue;

    private OptionalValueField(Class<V> valueType) {
        super(valueType);
    }

    public static <V2> OptionalValueField<V2> withInitialValue(V2 initialValue) {
        OptionalValueField<?> optionalValue = OptionalValueField.withValueType(initialValue.getClass());
        optionalValue.setValue(initialValue);
        return optionalValue;
    }

    public static <V2> OptionalValueField<V2> withValueType(Class<V2> valueType) {
        return new OptionalValueField<V2>(valueType);
    }

    @Override
    public void clear() {
        this.internalValue = null;
        this.setAsEditedAndRunPotentialUpdateAction();
    }

    @Override
    public boolean isEmpty() {
        return this.internalValue == null;
    }

    @Override
    public V getStoredValue() {
        OPTIONAL_VALUE_VALIDATOR.assertContainsValue(this);
        return this.internalValue;
    }

    @Override
    public FieldType getType() {
        return FieldType.OPTIONAL_VALUE_FIELD;
    }

    @Override
    public void internalSetNullableValue(Object nullableValue, String nullableAdditionalValue) {
        this.internalValue = nullableValue;
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public void setValue(V value) {
        OPTIONAL_VALUE_VALIDATOR.assertCanSetValue(this, value);
        this.updateStateForSetValue(value);
        this.setAsEditedAndRunPotentialUpdateAction();
    }

    @Override
    public void setValueFromString(String string) {
        DataType dataType = DataType.forType(this.getValueType());
        Object value = VALUE_MAPPER.mapStringToValue(string, dataType);
        this.setValue(value);
    }

    private void updateStateForSetValue(V value) {
        Validator.assertThat(value).thatIsNamed("value").isNotNull();
        this.internalValue = value;
    }
}

