/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.entitytool.TableNameExtractor;
import ch.nolix.system.objectdata.fieldexaminer.FieldExaminer;
import ch.nolix.system.objectdata.fieldvalidator.ReferenceValidator;
import ch.nolix.system.objectdata.model.AbstractBaseReference;
import ch.nolix.system.objectdata.model.BaseBackReferenceUpdater;
import ch.nolix.system.objectdata.model.BaseReferenceUpdater;
import ch.nolix.system.objectdata.modelsearcher.EntitySearcher;
import ch.nolix.systemapi.databaseobject.property.DatabaseObjectState;
import ch.nolix.systemapi.midschema.fieldproperty.FieldType;
import ch.nolix.systemapi.objectdata.entitytool.ITableNameExtractor;
import ch.nolix.systemapi.objectdata.fieldexaminer.IFieldExaminer;
import ch.nolix.systemapi.objectdata.fieldvalidator.IReferenceValidator;
import ch.nolix.systemapi.objectdata.model.IBaseBackReference;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.model.IReference;
import ch.nolix.systemapi.objectdata.model.ITable;
import ch.nolix.systemapi.objectdata.modelsearcher.IEntitySearcher;
import ch.nolix.systemapi.objectdata.structure.CachedEntityDto;
import java.util.Optional;

public final class Reference<E extends IEntity>
extends AbstractBaseReference<E>
implements IReference<E> {
    private static final ITableNameExtractor TABLE_NAME_EXTRACTOR = new TableNameExtractor();
    private static final IEntitySearcher ENTITY_SEARCHER = new EntitySearcher();
    private static final IFieldExaminer FIELD_EXAMINER = new FieldExaminer();
    private static final IReferenceValidator REFERENCE_VALIDATOR = new ReferenceValidator();
    private CachedEntityDto<E> cachedEntityDto;

    private Reference(IContainer<String> referenceableTableNames) {
        super(referenceableTableNames);
    }

    @SafeVarargs
    public static <E2 extends IEntity> Reference<E2> forEntityType(Class<? extends E2> entity, Class<? extends E2> ... entityTypes) {
        ContainerView<Class<String>> allEntityTypes = ContainerView.forElementAndArray(entity, entityTypes);
        IContainer<String> referenceableTableNames = allEntityTypes.to(TABLE_NAME_EXTRACTOR::getTableNameOfEntityType);
        return new Reference(referenceableTableNames);
    }

    public static <E2 extends IEntity> Reference<E2> forReferenceableTableName(String referenceableTableName, String ... referenceableTableNames) {
        ContainerView<String> allReferenceableTableNames = ContainerView.forElementAndArray(referenceableTableName, referenceableTableNames);
        return new Reference(allReferenceableTableNames);
    }

    public static <E2 extends IEntity> Reference<E2> forReferenceableTableNames(IContainer<String> referenceableTableNames) {
        return new Reference(referenceableTableNames);
    }

    @Override
    public String getReferencedEntityId() {
        REFERENCE_VALIDATOR.assertIsNotEmpty(this);
        return this.cachedEntityDto.id();
    }

    @Override
    public IContainer<IBaseBackReference<IEntity>> getStoredBaseBackReferencesWhoReferencesBackThis() {
        if (this.isEmpty()) {
            return ImmutableList.createEmpty();
        }
        IContainer<? extends IField> fields = this.getStoredReferencedEntity().internalGetStoredFields();
        Optional<IField> abstractBackReferenceContainer = fields.getOptionalStoredFirst(f -> f.referencesBackField(this));
        if (abstractBackReferenceContainer.isPresent()) {
            IBaseBackReference abstractBackReference = (IBaseBackReference)abstractBackReferenceContainer.get();
            return ImmutableList.withElement(abstractBackReference, new IBaseBackReference[0]);
        }
        return ImmutableList.createEmpty();
    }

    @Override
    public E getStoredReferencedEntity() {
        REFERENCE_VALIDATOR.assertIsNotEmpty(this);
        if (this.cachedEntityDto.nullableEntity() == null) {
            String id = this.cachedEntityDto.id();
            String tableId = this.cachedEntityDto.nullableTableId();
            Object entity = this.getStoredReferencedTable().getStoredEntityById(id);
            this.cachedEntityDto = new CachedEntityDto(id, tableId, entity);
        }
        return (E)((IEntity)this.cachedEntityDto.nullableEntity());
    }

    @Override
    public FieldType getType() {
        return FieldType.REFERENCE;
    }

    @Override
    public void internalSetNullableValue(Object nullableValue, String nullableAdditionalValue) {
        String id = (String)nullableValue;
        String tableId = nullableAdditionalValue;
        this.cachedEntityDto = new CachedEntityDto<Object>(id, tableId, null);
    }

    @Override
    public boolean isEmpty() {
        return this.cachedEntityDto == null;
    }

    @Override
    public boolean isMandatory() {
        return true;
    }

    @Override
    public boolean referencesEntity(IEntity entity) {
        return this.containsAny() && entity != null && this.getReferencedEntityId().equals(entity.getId());
    }

    @Override
    public boolean referencesUninsertedEntity() {
        return this.containsAny() && !this.getStoredReferencedEntity().belongsToTable();
    }

    @Override
    public void setEntity(Object entity) {
        this.setCastedEntity((IEntity)entity);
    }

    @Override
    public void setEntityById(String id) {
        Object entity = this.getStoredReferencedTable().getStoredEntityById(id);
        this.setEntity(entity);
    }

    @Override
    protected void noteInsertIntoDatabase() {
        if (this.containsAny()) {
            String id = this.cachedEntityDto.id();
            IEntity entity = (IEntity)this.cachedEntityDto.nullableEntity();
            String tableName = entity.getParentTableName();
            String tableId = this.getStoredParentEntity().getStoredParentDatabase().getStoredTableByName(tableName).getId();
            this.cachedEntityDto = new CachedEntityDto<IEntity>(id, tableId, entity);
            this.updateProbableBackReferenceForSetOrAddedEntity(this.getStoredReferencedEntity());
        }
    }

    private void assertCanSetEntity(E entity) {
        REFERENCE_VALIDATOR.assertCanSetGivenEntity(this, entity);
    }

    private void clear() {
        if (this.containsAny()) {
            this.clearWhenContainsAny();
        }
    }

    private void clearWhenContainsAny() {
        this.updateProbableBackReferencingFieldForClear();
        this.updateStateForClear();
        this.setAsEditedAndRunPotentialUpdateAction();
    }

    private Optional<? extends IField> getOptionalPendantReferencingFieldToEntity(E entity) {
        return ENTITY_SEARCHER.getStoredFieldsWhoAreBackReferencedFromEntity((IEntity)entity).getOptionalStoredFirst(rp -> rp.hasName(this.getName()));
    }

    private void insertEntityIntoDatabaseIfPossible(E entity) {
        if (this.belongsToEntity() && this.getStoredParentEntity().belongsToTable() && entity.getState() == DatabaseObjectState.NEW && !entity.belongsToTable()) {
            this.getStoredParentEntity().getStoredParentDatabase().insertEntity(entity);
        }
    }

    private void setCastedEntity(E entity) {
        this.assertCanSetEntity(entity);
        this.updatePropableBackReferencingFieldOfEntityForClear(entity);
        this.clear();
        this.updateStateForSetEntity(entity);
        this.updatePotentialBaseBackReferenceOfEntityForSetEntity(entity);
        this.insertEntityIntoDatabaseIfPossible(entity);
        this.setAsEditedAndRunPotentialUpdateAction();
    }

    private void updatePotentialBaseBackReferenceOfEntityForSetEntity(E entity) {
        BaseReferenceUpdater.ofBaseReferenceUpdatePotentialBaseBackReferenceForAddOrSetEntity(this, entity);
    }

    private void updateProbableBackReferencingFieldForClear() {
        for (IBaseBackReference iBaseBackReference : this.getStoredBaseBackReferencesWhoReferencesBackThis()) {
            BaseBackReferenceUpdater.updateBaseBackReferenceForClearBaseReference(iBaseBackReference);
        }
    }

    private void updatePropableBackReferencingFieldOfEntityForClear(E entity) {
        for (IBaseBackReference iBaseBackReference : this.getStoredBaseBackReferencesWhoReferencesBackThis()) {
            Optional<IField> pendantReferencingField;
            if (!FIELD_EXAMINER.isForSingleContent(iBaseBackReference) || !(pendantReferencingField = this.getOptionalPendantReferencingFieldToEntity(entity)).isPresent()) continue;
            Reference reference = (Reference)pendantReferencingField.get();
            reference.clear();
        }
    }

    private void updateStateForClear() {
        this.cachedEntityDto = null;
    }

    private void updateStateForSetEntity(E entity) {
        String id = entity.getId();
        if (entity.belongsToTable()) {
            String tableId = ((ITable)entity.getStoredParentTable()).getId();
            this.cachedEntityDto = new CachedEntityDto<E>(id, tableId, entity);
        } else {
            this.cachedEntityDto = new CachedEntityDto<E>(id, null, entity);
        }
    }
}

