/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.modelsearcher;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.coreapi.attribute.mandatoryattribute.IIdHolder;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.databaseobject.modelexaminer.DatabaseObjectExaminer;
import ch.nolix.systemapi.databaseobject.request.DeletionRequestable;
import ch.nolix.systemapi.objectdata.model.IDatabase;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.ITable;
import ch.nolix.systemapi.objectdata.modelsearcher.ITableSearcher;
import ch.nolix.systemapi.objectdata.schemaview.IColumnView;

public final class TableSearcher
extends DatabaseObjectExaminer
implements ITableSearcher {
    @Override
    public IContainer<String> getLocallyDeletedEntityIds(ITable<?> table) {
        if (table == null) {
            return ImmutableList.createEmpty();
        }
        return table.internalGetStoredEntitiesInLocalData().getStoredSelected(DeletionRequestable::isDeleted).to(IIdHolder::getId);
    }

    @Override
    public <E extends IEntity> IContainer<IColumnView<ITable<IEntity>>> getStoredColumsThatReferencesTable(ITable<E> table) {
        if (table == null) {
            return ImmutableList.createEmpty();
        }
        LinkedList<IColumnView<ITable<IEntity>>> columnViews = LinkedList.createEmpty();
        for (ITable iTable : ((IDatabase)table.getStoredParentDatabase()).getStoredTables()) {
            for (IColumnView iColumnView : iTable.getStoredColumns()) {
                if (!iColumnView.getContentModel().referencesTable(table)) continue;
                columnViews.addAtEnd(iColumnView);
            }
        }
        return columnViews;
    }
}

