/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectschema.model;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.datamodel.id.IdCreator;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.datamodel.fieldproperty.DataType;
import ch.nolix.system.objectschema.midschemamodelmapper.ContentModelDtoMapper;
import ch.nolix.system.objectschema.model.AbstractSchemaObject;
import ch.nolix.system.objectschema.model.ColumnEditor;
import ch.nolix.system.objectschema.model.Database;
import ch.nolix.system.objectschema.model.Table;
import ch.nolix.system.objectschema.model.ValueModel;
import ch.nolix.system.objectschema.schematool.ColumnTool;
import ch.nolix.systemapi.midschema.adapter.ISchemaAdapter;
import ch.nolix.systemapi.midschema.model.IContentModelDto;
import ch.nolix.systemapi.objectschema.midschemamodelmapper.IContentModelDtoMapper;
import ch.nolix.systemapi.objectschema.model.IColumn;
import ch.nolix.systemapi.objectschema.model.IContentModel;
import ch.nolix.systemapi.objectschema.modeleditor.IColumnEditor;
import ch.nolix.systemapi.objectschema.schematool.IColumnTool;

public final class Column
extends AbstractSchemaObject
implements IColumn {
    private static final String INITIAL_HEADER = "Default";
    private static final IContentModelDtoMapper CONTENT_MODEL_DTO_MAPPER = new ContentModelDtoMapper();
    private static final IColumnEditor<Column> COLUMN_EDITOR = new ColumnEditor();
    private static final IColumnTool COLUMN_TOOL = new ColumnTool();
    private final String id;
    private String name = "Default";
    private IContentModel contentModel = ValueModel.forDataType(DataType.INTEGER_4BYTE);
    private Table parentTable;

    public Column(String name, IContentModel contentModel) {
        this(IdCreator.createIdOf10HexadecimalCharacters(), name, contentModel);
    }

    private Column(String id, String name, IContentModel contentModel) {
        Validator.assertThat(id).thatIsNamed("id").isNotBlank();
        this.id = id;
        this.setName(name);
        this.setContentModel(contentModel);
    }

    public static Column withIdAndNameAndContentModel(String id, String name, IContentModel contentModel) {
        return new Column(id, name, contentModel);
    }

    @Override
    public boolean belongsToTable() {
        return this.parentTable != null;
    }

    @Override
    public void delete() {
        COLUMN_EDITOR.deleteColumn(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IContentModel getContentModel() {
        return this.contentModel;
    }

    @Override
    public Table getStoredParentTable() {
        COLUMN_TOOL.assertBelongsToTable(this);
        return this.parentTable;
    }

    @Override
    public boolean isBackReferenced() {
        if (!COLUMN_TOOL.isAReferenceColumn(this)) {
            return false;
        }
        return this.isBackReferencedWhenIsAnyReferenceColumn();
    }

    @Override
    public boolean isConnectedWithRealDatabase() {
        return this.belongsToTable() && this.getStoredParentTable().isConnectedWithRealDatabase();
    }

    @Override
    public boolean isEmpty() {
        return this.isNew() || this.getStoredMidSchemaAdapter().columnIsEmpty(this.getStoredParentTable().getName(), this.getName());
    }

    @Override
    public Column setContentModel(IContentModel contentModel) {
        COLUMN_EDITOR.setContentModelToColumn(this, contentModel);
        return this;
    }

    @Override
    public Column setName(String name) {
        COLUMN_EDITOR.setNameToColumn(this, name);
        return this;
    }

    IContainer<? extends IColumn> getStoredBackReferencingColumns() {
        if (!COLUMN_TOOL.isAReferenceColumn(this)) {
            return LinkedList.createEmpty();
        }
        return this.getStoredBackReferencingColumnsWhenIsReferenceColumn();
    }

    ISchemaAdapter getStoredMidSchemaAdapter() {
        return ((Database)COLUMN_TOOL.getParentDatabase(this)).getStoredMidSchemaAdapter();
    }

    void setContentModelAttribute(IContentModel contentModel) {
        Validator.assertThat(contentModel).thatIsNamed(IContentModel.class).isNotNull();
        this.contentModel = contentModel;
    }

    void internalSetContentModelToDatabase() {
        Table table = this.getStoredParentTable();
        String tableName = table.getName();
        IContentModelDto contentModelDto = CONTENT_MODEL_DTO_MAPPER.mapContentModelToContentModelDto(this.getContentModel());
        this.getStoredMidSchemaAdapter().setContentModel(tableName, this.getName(), contentModelDto);
    }

    void setNameAttribute(String header) {
        this.name = header;
    }

    void setParentTableAttribute(Table parentTable) {
        this.parentTable = parentTable;
    }

    @Override
    protected void noteClose() {
    }

    private IContainer<? extends IColumn> getStoredBackReferencingColumnsWhenIsReferenceColumn() {
        if (COLUMN_TOOL.belongsToDatabase(this)) {
            return COLUMN_TOOL.getParentDatabase(this).getStoredTables().toMultiples(t -> t.getStoredColumns().getStoredSelected(c -> COLUMN_TOOL.referencesBackGivenColumn((IColumn)c, this)));
        }
        if (this.belongsToTable()) {
            return this.getStoredParentTable().getStoredColumns().getStoredSelected(c -> COLUMN_TOOL.referencesBackGivenColumn((IColumn)c, this));
        }
        return LinkedList.createEmpty();
    }

    private boolean isBackReferencedWhenIsAnyReferenceColumn() {
        if (COLUMN_TOOL.belongsToDatabase(this)) {
            return COLUMN_TOOL.getParentDatabase(this).getStoredTables().containsAny(t -> t.getStoredColumns().containsAny(c -> COLUMN_TOOL.referencesBackGivenColumn((IColumn)c, this)));
        }
        if (this.belongsToTable()) {
            return this.getStoredParentTable().getStoredColumns().containsAny(c -> COLUMN_TOOL.referencesBackGivenColumn((IColumn)c, this));
        }
        return false;
    }
}

