/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectschema.model;

import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectschema.midschemamodelmapper.ContentModelDtoMapper;
import ch.nolix.system.objectschema.model.Column;
import ch.nolix.system.objectschema.model.Table;
import ch.nolix.system.objectschema.modelmutationvalidator.ColumnMutationValidator;
import ch.nolix.systemapi.midschema.model.IContentModelDto;
import ch.nolix.systemapi.objectschema.midschemamodelmapper.IContentModelDtoMapper;
import ch.nolix.systemapi.objectschema.model.IColumn;
import ch.nolix.systemapi.objectschema.model.IContentModel;
import ch.nolix.systemapi.objectschema.modeleditor.IColumnEditor;

public final class ColumnEditor
implements IColumnEditor<Column> {
    private static final ColumnMutationValidator COLUMN_MUTATION_VALIDATOR = new ColumnMutationValidator();
    private static final IContentModelDtoMapper CONTENT_MODEL_DTO_MAPPER = new ContentModelDtoMapper();

    @Override
    public void deleteColumn(Column column) {
        COLUMN_MUTATION_VALIDATOR.assertCanBeDeleted(column);
        if (column.belongsToTable()) {
            column.getStoredParentTable().removeColumnAttribute(column);
        }
        column.getStoredMidSchemaAdapter().deleteColumn(column.getStoredParentTable().getName(), column.getName());
        column.setDeleted();
    }

    @Override
    public void setContentModelToColumn(Column column, IContentModel contentModel) {
        COLUMN_MUTATION_VALIDATOR.assertCanSetContentModel(column, contentModel);
        column.setContentModelAttribute(contentModel);
        if (column.isConnectedWithRealDatabase()) {
            Table table = column.getStoredParentTable();
            String tableName = table.getName();
            String columnName = column.getName();
            IContentModelDto contentModelDto = CONTENT_MODEL_DTO_MAPPER.mapContentModelToContentModelDto(contentModel);
            column.getStoredMidSchemaAdapter().setContentModel(tableName, columnName, contentModelDto);
        }
        column.setEdited();
    }

    @Override
    public void setNameToColumn(Column column, String name) {
        COLUMN_MUTATION_VALIDATOR.assertCanSetName(column, name);
        String oldName = column.getName();
        IContainer<? extends IColumn> backReferencingColumns = column.getStoredBackReferencingColumns();
        column.setNameAttribute(name);
        if (column.isConnectedWithRealDatabase()) {
            String string = column.getStoredParentTable().getName();
            column.getStoredMidSchemaAdapter().renameColumn(string, oldName, name);
        }
        for (IColumn iColumn : backReferencingColumns) {
            ((Column)iColumn).internalSetContentModelToDatabase();
        }
        column.setEdited();
    }
}

