/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectschema.model;

import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectschema.midschemamodelmapper.ColumnDtoMapper;
import ch.nolix.system.objectschema.model.Column;
import ch.nolix.system.objectschema.model.Table;
import ch.nolix.system.objectschema.schematool.TableTool;
import ch.nolix.systemapi.midschema.adapter.ISchemaAdapter;
import ch.nolix.systemapi.midschema.model.ColumnDto;
import ch.nolix.systemapi.objectschema.midschemamodelmapper.IColumnDtoMapper;
import ch.nolix.systemapi.objectschema.model.IColumn;
import ch.nolix.systemapi.objectschema.schematool.ITableTool;

public final class TableEditor {
    private static final ITableTool TABLE_TOOL = new TableTool();
    private static final IColumnDtoMapper COLUMN_DTO_MAPPER = new ColumnDtoMapper();

    private TableEditor() {
    }

    public static void addColumnToTable(Table table, Column column) {
        table.addColumnAttribute(column);
        column.setParentTableAttribute(table);
        if (table.isConnectedWithRealDatabase()) {
            ISchemaAdapter midSchemaAdapter = table.getStoredMidSchemaAdapter();
            String tableName = table.getName();
            ColumnDto columnDto = COLUMN_DTO_MAPPER.mapColumnToMidSchemaColumnDto(column);
            midSchemaAdapter.addColumn(tableName, columnDto);
        }
        table.setEdited();
    }

    public static void deleteTable(Table table) {
        if (table.belongsToDatabase()) {
            table.getStoredParentDatabase().removeTableAttribute(table);
        }
        String tableName = table.getName();
        table.getStoredMidSchemaAdapter().deleteTable(tableName);
        table.setDeleted();
    }

    public static void setNameToTable(Table table, String name) {
        String oldTableName = table.getName();
        IContainer<? extends IColumn> referencingColumns = TABLE_TOOL.getStoredReferencingColumns(table);
        IContainer<? extends IColumn> backReferencingColumns = TABLE_TOOL.getStoredBackReferencingColumns(table);
        table.setNameAttribute(name);
        if (table.isConnectedWithRealDatabase()) {
            table.getStoredMidSchemaAdapter().renameTable(oldTableName, name);
            for (IColumn iColumn : referencingColumns) {
                ((Column)iColumn).internalSetContentModelToDatabase();
            }
            for (IColumn iColumn : backReferencingColumns) {
                ((Column)iColumn).internalSetContentModelToDatabase();
            }
        }
        table.setEdited();
    }
}

