/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectschema.modelmutationvalidator;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.databaseobject.modelvalidator.DatabaseObjectValidator;
import ch.nolix.system.objectschema.model.AbstractBaseBackReferenceModel;
import ch.nolix.system.objectschema.model.AbstractBaseReferenceModel;
import ch.nolix.system.objectschema.modelvalidator.DatabaseValidator;
import ch.nolix.system.objectschema.modelvalidator.TableValidator;
import ch.nolix.system.objectschema.schematool.ColumnTool;
import ch.nolix.system.objectschema.schematool.DatabaseTool;
import ch.nolix.systemapi.databaseobject.modelvalidator.IDatabaseObjectValidator;
import ch.nolix.systemapi.objectschema.model.IColumn;
import ch.nolix.systemapi.objectschema.model.IDatabase;
import ch.nolix.systemapi.objectschema.model.ITable;
import ch.nolix.systemapi.objectschema.modelmutationvalidator.ITableMutationValidator;
import ch.nolix.systemapi.objectschema.modelvalidator.IDatabaseValidator;
import ch.nolix.systemapi.objectschema.modelvalidator.ITableValidator;
import ch.nolix.systemapi.objectschema.schematool.IColumnTool;
import ch.nolix.systemapi.objectschema.schematool.IDatabaseTool;

public final class TableMutationValidator
implements ITableMutationValidator {
    private static final IDatabaseObjectValidator DATABASE_OBJECT_VALIDATOR = new DatabaseObjectValidator();
    private static final IDatabaseTool DATABASE_TOOL = new DatabaseTool();
    private static final IDatabaseValidator DATABASE_VALIDATOR = new DatabaseValidator();
    private static final ITableValidator TABLE_VALIDATOR = new TableValidator();
    private static final IColumnTool COLUMN_TOOL = new ColumnTool();

    @Override
    public void assertCanAddColumnToTable(ITable table, IColumn column) {
        DATABASE_OBJECT_VALIDATOR.assertIsOpen(table);
        TABLE_VALIDATOR.assertDoesNotContainColumnWithName(table, column.getName());
        DATABASE_OBJECT_VALIDATOR.assertIsOpen(column);
        DATABASE_OBJECT_VALIDATOR.assertIsNew(column);
        if (COLUMN_TOOL.isAReferenceColumn(column) && table.belongsToDatabase()) {
            AbstractBaseReferenceModel abstractReferenceModel = (AbstractBaseReferenceModel)column.getContentModel();
            IContainer<? extends ITable> referencedTables = abstractReferenceModel.getReferenceableTables();
            IDatabase database = (IDatabase)table.getStoredParentDatabase();
            referencedTables.forEach(t -> DATABASE_VALIDATOR.assertContainsTable(database, (ITable)t));
        }
        if (COLUMN_TOOL.isABackReferenceColumn(column) && table.belongsToDatabase()) {
            AbstractBaseBackReferenceModel abstractBackReferenceModel = (AbstractBaseBackReferenceModel)column.getContentModel();
            IColumn backReferencedColumn = abstractBackReferenceModel.getBackReferencedColumn();
            DATABASE_TOOL.assertContainsTableWithGivenColumn((IDatabase)table.getStoredParentDatabase(), backReferencedColumn);
        }
    }

    @Override
    public void assertCanDeleteTable(ITable table) {
        DATABASE_OBJECT_VALIDATOR.assertIsOpen(table);
        DATABASE_OBJECT_VALIDATOR.assertIsNotNew(table);
        DATABASE_OBJECT_VALIDATOR.assertIsNotDeleted(table);
        TABLE_VALIDATOR.assertIsNotReferenced(table);
    }

    @Override
    public void assertCanSetNameToTable(ITable table, String name) {
        DATABASE_OBJECT_VALIDATOR.assertIsOpen(table);
        if (table.belongsToDatabase()) {
            DATABASE_TOOL.assertDoesNotContainTableWithGivenName((IDatabase)table.getStoredParentDatabase(), name);
        }
        Validator.assertThat(name).thatIsNamed("name").isNotBlank();
    }
}

