/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.sqlmiddata.datawriter;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.resourcecontrol.closecontroller.CloseController;
import ch.nolix.coreapi.resourcecontrol.closecontroller.ICloseController;
import ch.nolix.coreapi.sql.connection.ISqlConnection;
import ch.nolix.system.midschemaview.modelsearcher.DatabaseViewSearcher;
import ch.nolix.system.sqlmiddata.datawriter.ExecutiveDataWriter;
import ch.nolix.systemapi.middata.adapter.IDataWriter;
import ch.nolix.systemapi.middata.model.EntityCreationDto;
import ch.nolix.systemapi.middata.model.EntityDeletionDto;
import ch.nolix.systemapi.middata.model.EntityUpdateDto;
import ch.nolix.systemapi.middata.model.MultiBackReferenceEntryDeletionDto;
import ch.nolix.systemapi.middata.model.MultiBackReferenceEntryDto;
import ch.nolix.systemapi.middata.model.MultiReferenceEntryDeletionDto;
import ch.nolix.systemapi.middata.model.MultiReferenceEntryDto;
import ch.nolix.systemapi.middata.model.MultiValueEntryDto;
import ch.nolix.systemapi.midschemaview.model.ColumnViewDto;
import ch.nolix.systemapi.midschemaview.model.DatabaseViewDto;
import ch.nolix.systemapi.midschemaview.modelsearcher.IDatabaseViewSearcher;
import ch.nolix.systemapi.time.moment.ITime;

public final class DataWriter
implements IDataWriter {
    private static final IDatabaseViewSearcher DATABASE_VIEW_SEARCHER = new DatabaseViewSearcher();
    private final ICloseController closeController = CloseController.forElement(this);
    private final DatabaseViewDto databaseView;
    private final ExecutiveDataWriter executiveDataWriter;

    private DataWriter(String databaseName, DatabaseViewDto databaseView, ISqlConnection sqlConnection) {
        Validator.assertThat(databaseView).thatIsNamed("database view").isNotNull();
        this.databaseView = databaseView;
        this.executiveDataWriter = new ExecutiveDataWriter(databaseName, sqlConnection);
        this.createCloseDependencyTo(sqlConnection);
    }

    public static DataWriter forDatabaseNameAndDatabaseViewAndSqlConnection(String databaseName, DatabaseViewDto databaseView, ISqlConnection sqlConnection) {
        return new DataWriter(databaseName, databaseView, sqlConnection);
    }

    @Override
    public void clearMultiReference(String tableName, String entityId, String multiReferenceColumnName) {
        ColumnViewDto multiReferenceColumnView = this.getColumnViewByTableNameAndColumnName(tableName, multiReferenceColumnName);
        String multiReferenceColumnId = multiReferenceColumnView.id();
        this.executiveDataWriter.deleteEntriesFromMultiReference(entityId, multiReferenceColumnId);
    }

    @Override
    public void clearMultiValue(String tableName, String entityId, String multiValueColumnName) {
        ColumnViewDto multiValueColumnView = this.getColumnViewByTableNameAndColumnName(tableName, multiValueColumnName);
        String multiValueColumnId = multiValueColumnView.id();
        this.executiveDataWriter.deleteEntriesFromMultiValue(entityId, multiValueColumnId);
    }

    @Override
    public void deleteEntity(String tableName, EntityDeletionDto entity) {
        this.executiveDataWriter.deleteEntity(tableName, entity);
    }

    @Override
    public void deleteMultiBackReferenceEntry(MultiBackReferenceEntryDeletionDto multiBackReferenceEntry) {
        String entityId = multiBackReferenceEntry.entityId();
        String multiBackReferenceColumnId = multiBackReferenceEntry.multiBackReferenceColumnId();
        String backReferencedEntityId = multiBackReferenceEntry.backReferencedEntityId();
        this.executiveDataWriter.deleteMultiBackReferenceEntry(entityId, multiBackReferenceColumnId, backReferencedEntityId);
    }

    @Override
    public void deleteMultiReferenceEntry(MultiReferenceEntryDeletionDto multiReferenceEntry) {
        String entityId = multiReferenceEntry.entityId();
        String multiReferenceColumnId = multiReferenceEntry.multiReferenceColumnId();
        String referencedEntityId = multiReferenceEntry.referencedEntityId();
        this.executiveDataWriter.deleteEntryFromMultiReference(entityId, multiReferenceColumnId, referencedEntityId);
    }

    @Override
    public void deleteMultiValueEntry(MultiValueEntryDto multiValueEntry) {
        String entityId = multiValueEntry.entityId();
        String multiValueColumnId = multiValueEntry.multiValueColumnId();
        String value = multiValueEntry.value();
        this.executiveDataWriter.deleteMultiValueEntry(entityId, multiValueColumnId, value);
    }

    @Override
    public void expectSchemaTimestamp(ITime schemaTimestamp) {
        this.executiveDataWriter.expectGivenSchemaTimestamp(schemaTimestamp);
    }

    @Override
    public void expectTableContainsEntity(String tableName, String entityId) {
        this.executiveDataWriter.expectTableContainsEntity(tableName, entityId);
    }

    @Override
    public ICloseController getStoredCloseController() {
        return this.closeController;
    }

    @Override
    public int getSaveCount() {
        return this.executiveDataWriter.getSaveCount();
    }

    @Override
    public boolean hasChanges() {
        return this.executiveDataWriter.hasChanges();
    }

    @Override
    public void insertEntity(String tableName, EntityCreationDto newEntity) {
        this.executiveDataWriter.insertEntity(tableName, newEntity);
    }

    @Override
    public void insertMultiBackReferenceEntry(MultiBackReferenceEntryDto multiBackReferenceEntry) {
        String entityId = multiBackReferenceEntry.entityId();
        String multiBackReferenceColumnId = multiBackReferenceEntry.multiBackReferenceColumnId();
        String backReferencedEntityId = multiBackReferenceEntry.backReferencedEntityId();
        String backReferencedEntityTableId = multiBackReferenceEntry.backReferencedEntityTableId();
        this.executiveDataWriter.insertEntryIntoMultiBackReference(entityId, multiBackReferenceColumnId, backReferencedEntityId, backReferencedEntityTableId);
    }

    @Override
    public void insertMultiReferenceEntry(MultiReferenceEntryDto multiReferenceEntry) {
        String entityId = multiReferenceEntry.entityId();
        String multiReferenceColumnId = multiReferenceEntry.multiReferenceColumnId();
        String referencedEntityId = multiReferenceEntry.referencedEntityId();
        String referencedEntityTableId = multiReferenceEntry.referencedEntityId();
        this.executiveDataWriter.insertMultiReferenceEntry(entityId, multiReferenceColumnId, referencedEntityId, referencedEntityTableId);
    }

    @Override
    public void insertMultiValueEntry(MultiValueEntryDto multiValueEntry) {
        String entityId = multiValueEntry.entityId();
        String multiValueColumnId = multiValueEntry.multiValueColumnId();
        String value = multiValueEntry.value();
        this.executiveDataWriter.insertEntryIntoMultiValue(entityId, multiValueColumnId, value);
    }

    @Override
    public void noteClose() {
    }

    @Override
    public void reset() {
        this.executiveDataWriter.reset();
    }

    @Override
    public void saveChanges() {
        this.executiveDataWriter.saveChangesAndReset();
    }

    @Override
    public void updateEntity(String tableName, EntityUpdateDto entityUpdate) {
        this.executiveDataWriter.updateEntityOnTable(tableName, entityUpdate);
    }

    private ColumnViewDto getColumnViewByTableNameAndColumnName(String tableName, String columnName) {
        return DATABASE_VIEW_SEARCHER.getColumnViewByTableNameAndColumnName(this.databaseView, tableName, columnName);
    }
}

