/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.sqlmidschema.schemawriter;

import ch.nolix.core.resourcecontrol.closecontroller.CloseController;
import ch.nolix.core.sql.sqltool.SqlCollector;
import ch.nolix.coreapi.resourcecontrol.closecontroller.ICloseController;
import ch.nolix.coreapi.sql.connection.ISqlConnection;
import ch.nolix.system.sqlmidschema.schemawriter.MetaDataWriter;
import ch.nolix.system.sqlmidschema.sqlschemamodelmapper.SqlSchemaColumnDtoMapper;
import ch.nolix.system.sqlmidschema.sqlschemamodelmapper.SqlSchemaTableDtoMapper;
import ch.nolix.system.time.moment.IncrementalCurrentTimeCreator;
import ch.nolix.systemapi.midschema.adapter.ISchemaWriter;
import ch.nolix.systemapi.midschema.model.ColumnDto;
import ch.nolix.systemapi.midschema.model.IContentModelDto;
import ch.nolix.systemapi.midschema.model.TableDto;
import ch.nolix.systemapi.sqlmidschema.sqlschemamodelmapper.ISqlSchemaColumnDtoMapper;
import ch.nolix.systemapi.sqlmidschema.sqlschemamodelmapper.ISqlSchemaTableDtoMapper;
import ch.nolix.systemapi.time.moment.IIncrementalCurrentTimeCreator;

public final class SchemaWriter
implements ISchemaWriter {
    private static final ISqlSchemaTableDtoMapper SQL_SCHEMA_TABLE_DTO_MAPPER = new SqlSchemaTableDtoMapper();
    private static final ISqlSchemaColumnDtoMapper SQL_SCHEMA_COLUMN_DTO_MAPPER = new SqlSchemaColumnDtoMapper();
    private static final IIncrementalCurrentTimeCreator INCREMENTAL_CURRENT_TIME_CREATOR = new IncrementalCurrentTimeCreator();
    private final ICloseController closeController = CloseController.forElement(this);
    private final MetaDataWriter metaDataWriter;
    private final ch.nolix.systemapi.sqlschema.adapter.ISchemaWriter sqlSchemaWriter;
    private final SqlCollector sqlCollector = new SqlCollector();
    private final ISqlConnection sqlConnection;
    private int saveCount;

    public SchemaWriter(String databaseName, ISqlConnection sqlConnection) {
        this.sqlConnection = sqlConnection;
        this.metaDataWriter = MetaDataWriter.forSqlCollector(this.sqlCollector);
        this.sqlSchemaWriter = ch.nolix.system.sqlschema.adapter.SchemaWriter.forDatabasNameAndSqlConnection(databaseName, sqlConnection);
        this.createCloseDependencyTo(this.sqlConnection);
        this.createCloseDependencyTo(this.sqlSchemaWriter);
    }

    public static SchemaWriter forDatabaseNameAndSqlConnection(String databaseName, ISqlConnection sqlConnection) {
        return new SchemaWriter(databaseName, sqlConnection);
    }

    @Override
    public void addColumn(String tableName, ColumnDto column) {
        this.metaDataWriter.addColumn(tableName, column);
        this.sqlSchemaWriter.addColumns(tableName, SQL_SCHEMA_COLUMN_DTO_MAPPER.mapColumnDtoToSqlSchemaColumnDtos(column));
    }

    @Override
    public void addTable(TableDto table) {
        this.metaDataWriter.addTable(table);
        this.sqlSchemaWriter.addTable(SQL_SCHEMA_TABLE_DTO_MAPPER.mapTableDtoSqlSchemaTableDto(table));
    }

    @Override
    public void deleteColumn(String tableName, String columnName) {
        String referencedTableColumnName = columnName + "$ReferencedTable";
        this.metaDataWriter.deleteColumn(tableName, columnName);
        this.sqlSchemaWriter.deleteColumn(tableName, columnName);
        this.sqlSchemaWriter.deleteColumnIfExists(tableName, referencedTableColumnName);
    }

    @Override
    public void deleteTable(String tableName) {
        this.metaDataWriter.deleteTable(tableName);
        this.sqlSchemaWriter.deleteTable(tableName);
    }

    @Override
    public ICloseController getStoredCloseController() {
        return this.closeController;
    }

    @Override
    public int getSaveCount() {
        return this.saveCount;
    }

    @Override
    public boolean hasChanges() {
        return this.sqlCollector.containsAny();
    }

    @Override
    public void noteClose() {
    }

    @Override
    public void renameColumn(String tableName, String columnName, String newColumnName) {
        String referencedTableColumnName = columnName + "$ReferencedTable";
        this.metaDataWriter.renameColumn(tableName, columnName, newColumnName);
        this.sqlSchemaWriter.renameColumn(tableName, columnName, newColumnName);
        this.sqlSchemaWriter.renameColumnIfExists(tableName, columnName, referencedTableColumnName);
    }

    @Override
    public void renameTable(String tableName, String newTableName) {
        this.metaDataWriter.renameTable(tableName, newTableName);
        this.sqlSchemaWriter.renameTable(tableName, newTableName);
    }

    @Override
    public void reset() {
        this.sqlCollector.clear();
    }

    @Override
    public void saveChanges() {
        try {
            this.metaDataWriter.setSchemaTimestamp(INCREMENTAL_CURRENT_TIME_CREATOR.getCurrentTime());
            this.sqlSchemaWriter.addAdditionalSqlStatements(this.sqlCollector.getSqlStatements());
            this.sqlCollector.executeAndClearUsingConnection(this.sqlConnection);
            ++this.saveCount;
        }
        finally {
            this.reset();
        }
    }

    @Override
    public void setContentModel(String tableName, String columnName, IContentModelDto contentModel) {
        this.metaDataWriter.setContentModel(tableName, columnName, contentModel);
    }
}

