/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.style.stylable;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.element.base.StructureSpecificationCreator;
import ch.nolix.system.element.mutableelement.AbstractMutableElement;
import ch.nolix.system.element.property.MultiValue;
import ch.nolix.system.element.property.MutableOptionalValue;
import ch.nolix.systemapi.element.base.IStructureElement;
import ch.nolix.systemapi.style.stylable.IStylableElement;

public abstract class AbstractStylableElement<E extends IStylableElement<E>>
extends AbstractMutableElement
implements IStylableElement<E> {
    private static final String ID_HEADER = "Id";
    private static final String TOKEN_HEADER = "Token";
    private static final StructureSpecificationCreator STRUCTURE_SPECIFICATION_CREATOR = new StructureSpecificationCreator();
    private final MutableOptionalValue<String> id = MutableOptionalValue.forString("Id", string -> this.setId((String)string));
    private final MultiValue<String> tokens = MultiValue.forStrings("Token", string -> this.addToken((String)string));

    @Override
    public final E addToken(String token) {
        Validator.assertThat(token).thatIsNamed("token").isNotBlank();
        this.tokens.add(token);
        return this.asConcrete();
    }

    @Override
    public final IContainer<? extends IStructureElement> getChildStructureElements() {
        return this.getStoredChildStylableElements();
    }

    @Override
    public final String getId() {
        return (String)this.id.getValue();
    }

    @Override
    public final IContainer<String> getTokens() {
        return this.tokens.getStoredValues();
    }

    @Override
    public final INode<?> getStructureSpecification() {
        return STRUCTURE_SPECIFICATION_CREATOR.getStructureSpecificationOfElement(this);
    }

    @Override
    public final boolean hasId() {
        return this.id.containsAny();
    }

    @Override
    public final void removeId() {
        this.id.clear();
    }

    @Override
    public final void removeToken(String token) {
        this.tokens.remove(token);
    }

    @Override
    public final void removeTokens() {
        this.tokens.clear();
    }

    @Override
    public final void reset() {
        this.removeId();
        this.removeTokens();
        this.resetStyleRecursively();
        this.resetStylableElement();
    }

    @Override
    public final void resetStyleRecursively() {
        this.resetStyle();
        this.getStoredChildStylableElements().forEach(IStylableElement::resetStyleRecursively);
    }

    @Override
    public final E setId(String id) {
        Validator.assertThat(id).thatIsNamed("id").isNotBlank();
        this.id.setValue(id);
        return this.asConcrete();
    }

    protected final E asConcrete() {
        return (E)this;
    }

    protected abstract void resetStylableElement();

    protected abstract void resetStyle();
}

