/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.style.tool;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.style.model.AttachingAttribute;
import ch.nolix.systemapi.style.model.IAttachingAttribute;
import ch.nolix.systemapi.style.tool.IAttributeMerger;
import java.util.Optional;

public final class AttributeMerger
implements IAttributeMerger {
    @Override
    public IContainer<IAttachingAttribute> getAttributesMergedWithNewAttributes(IContainer<? extends IAttachingAttribute> attributes, IContainer<String> newAttributes) {
        LinkedList<IAttachingAttribute> mergedAttachingAttributes = LinkedList.createEmpty();
        LinkedList<String> additionalAttributes = LinkedList.fromIterable(newAttributes);
        for (IAttachingAttribute iAttachingAttribute : attributes) {
            String attributeHeader = ((INode)iAttachingAttribute.getValue()).getHeader();
            Optional<String> newAttributeContainer = newAttributes.getOptionalStoredFirst(na -> na.startsWith(attributeHeader));
            if (newAttributeContainer.isPresent()) {
                String newAttribute = newAttributeContainer.get();
                additionalAttributes.removeFirstOccurrenceOf(newAttribute);
                mergedAttachingAttributes.addAtEnd(iAttachingAttribute.withValue(newAttribute));
                continue;
            }
            mergedAttachingAttributes.addAtEnd(iAttachingAttribute);
        }
        mergedAttachingAttributes.addAtEnd(additionalAttributes.to(AttachingAttribute::forValue));
        return mergedAttachingAttributes;
    }
}

