/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webapplication.protocol;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.document.chainednode.ChainedNode;
import ch.nolix.core.document.node.Node;
import ch.nolix.coreapi.document.chainednode.IChainedNode;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.coreapi.net.target.IServerTarget;
import ch.nolix.systemapi.webapplication.protocol.IClientCommandCreator;
import java.nio.charset.StandardCharsets;

public final class ClientCommandCreator
implements IClientCommandCreator {
    @Override
    public IChainedNode createAddOrSetCookieCommand(String name, String value) {
        return ChainedNode.withHeaderAndChildNodes("SetOrAddCookieWithNameAndValue", ImmutableList.withElement(ChainedNode.withHeader(name), ChainedNode.withHeader(value)));
    }

    @Override
    public IChainedNode createDeleteCookieCommand(String cookieName) {
        return ChainedNode.withHeaderAndChildNode("DeleteCookieByName", ChainedNode.withHeader(cookieName));
    }

    @Override
    public IChainedNode createOpenNewTabCommand(String url) {
        return ChainedNode.withHeaderAndChildNode("OpenNewTab", ChainedNode.withHeaderAndChildNode("URL", ChainedNode.withHeader(url)));
    }

    @Override
    public IChainedNode createRedirectCommand(IServerTarget serverTarget) {
        String url = serverTarget.toUrl();
        return this.createRedirectCommand(url);
    }

    @Override
    public IChainedNode createRedirectCommand(String url) {
        return ChainedNode.withHeaderAndChildNode("Redirect", ChainedNode.withHeader(url));
    }

    @Override
    public IChainedNode createSaveFileCommand(byte[] bytes) {
        return ChainedNode.withHeaderAndChildNodesFromNodes("SaveFile", Node.withHeader(new String(bytes, StandardCharsets.UTF_8)), new INode[0]);
    }

    @Override
    public IChainedNode createWriteTextToClipBoardCommand(String text) {
        return ChainedNode.withHeaderAndChildNode("WriteTextToClipBoard", ChainedNode.withHeader(text));
    }
}

