/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webgui.atomiccontrol.imagecontrol;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotSupportMethodException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.system.element.mutableelement.AbstractMutableElement;
import ch.nolix.system.element.property.MutableOptionalValue;
import ch.nolix.system.element.property.MutableValue;
import ch.nolix.system.graphic.color.X11ColorCatalog;
import ch.nolix.system.graphic.image.MutableImage;
import ch.nolix.system.webgui.atomiccontrol.imagecontrol.ImageControlCssBuilder;
import ch.nolix.system.webgui.atomiccontrol.imagecontrol.ImageControlHtmlBuilder;
import ch.nolix.system.webgui.atomiccontrol.imagecontrol.ImageControlStyle;
import ch.nolix.system.webgui.main.Control;
import ch.nolix.system.webgui.main.HtmlElementEvent;
import ch.nolix.systemapi.graphic.image.IImage;
import ch.nolix.systemapi.webgui.atomiccontrol.imagecontrolapi.IImageControl;
import ch.nolix.systemapi.webgui.atomiccontrol.imagecontrolapi.IImageControlStyle;
import ch.nolix.systemapi.webgui.controltool.IControlCssBuilder;
import ch.nolix.systemapi.webgui.controltool.IControlHtmlBuilder;
import ch.nolix.systemapi.webgui.main.ControlState;
import ch.nolix.systemapi.webgui.main.IControl;
import ch.nolix.systemapi.webgui.main.IHtmlElementEvent;
import java.util.Optional;
import java.util.function.Consumer;

public final class ImageControl
extends Control<IImageControl, IImageControlStyle>
implements IImageControl {
    public static final String DEFAULT_ALTERNATE_TEXT = "";
    private static final String IMAGE_HEADER = "Image";
    private static final String ALTERNATE_TEXT_HEADER = "AlternateText";
    private static final ImageControlHtmlBuilder HTML_BUILDER = new ImageControlHtmlBuilder();
    private static final ImageControlCssBuilder CSS_BUILDER = new ImageControlCssBuilder();
    private final MutableOptionalValue<MutableImage> image = new MutableOptionalValue<MutableImage>("Image", this::setImage, MutableImage::fromSpecification, AbstractMutableElement::getSpecification);
    private final MutableValue<String> alternateText = MutableValue.forString("AlternateText", "", this::setAlternateText);
    private Consumer<IImageControl> leftMouseButtonPressAction;
    private Consumer<IImageControl> leftMouseButtonReleaseAction;

    public ImageControl() {
        this.reset();
        ((IImageControlStyle)this.getStoredStyle()).setBackgroundColorForState(ControlState.BASE, X11ColorCatalog.LIGHT_GREY);
    }

    @Override
    public void clear() {
        this.image.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.image.isEmpty();
    }

    @Override
    public String getAlternateText() {
        return (String)this.alternateText.getValue();
    }

    @Override
    public Optional<String> getOptionalJavaScriptUserInputFunction() {
        return Optional.empty();
    }

    @Override
    public IContainer<IControl<?, ?>> getStoredChildControls() {
        return ImmutableList.createEmpty();
    }

    public MutableImage getStoredImage() {
        return (MutableImage)this.image.getValue();
    }

    @Override
    public String getUserInput() {
        return DEFAULT_ALTERNATE_TEXT;
    }

    @Override
    public boolean hasLeftMouseButtonPressAction() {
        return this.leftMouseButtonPressAction != null;
    }

    @Override
    public boolean hasLeftMouseButtonReleaseAction() {
        return this.leftMouseButtonReleaseAction != null;
    }

    @Override
    public boolean hasRole(String role) {
        return false;
    }

    @Override
    public void registerHtmlElementEventsAt(ILinkedList<IHtmlElementEvent> list) {
        list.addAtEnd(HtmlElementEvent.withHtmlElementIdAndHtmlEvent(this.getInternalId(), "onclick"));
    }

    @Override
    public void removeLeftMouseButtonPressAction() {
        this.leftMouseButtonPressAction = null;
    }

    @Override
    public void removeLeftMouseButtonReleaseAction() {
        this.leftMouseButtonReleaseAction = null;
    }

    @Override
    public void runHtmlEvent(String htmlEvent) {
        Validator.assertThat(htmlEvent).thatIsNamed("HTML event").isEqualTo("onclick");
        if (this.hasLeftMouseButtonPressAction()) {
            this.leftMouseButtonPressAction.accept(this);
        }
    }

    @Override
    public IImageControl setAlternateText(String alternateText) {
        this.alternateText.setValue(alternateText);
        return this;
    }

    @Override
    public IImageControl setImage(IImage image) {
        if (image instanceof MutableImage) {
            MutableImage mutableImage = (MutableImage)image;
            this.image.setValue(mutableImage);
        } else {
            this.image.setValue(MutableImage.fromAnyImage(image));
        }
        return this;
    }

    @Override
    public IImageControl setLeftMouseButtonPressAction(Runnable leftMouseButtonPressAction) {
        Validator.assertThat(leftMouseButtonPressAction).thatIsNamed("left mouse button press action").isNotNull();
        return this.setLeftMouseButtonPressAction((IImageControl b) -> leftMouseButtonPressAction.run());
    }

    @Override
    public IImageControl setLeftMouseButtonPressAction(Consumer<IImageControl> leftMouseButtonPressAction) {
        Validator.assertThat(leftMouseButtonPressAction).thatIsNamed("left mouse button press action").isNotNull();
        this.leftMouseButtonPressAction = leftMouseButtonPressAction;
        return this;
    }

    @Override
    public IImageControl setLeftMouseButtonRelaseAction(Runnable leftMouseButtonReleaseAction) {
        Validator.assertThat(leftMouseButtonReleaseAction).thatIsNamed("left mouse button release action").isNotNull();
        return this.setLeftMouseButtonRelaseAction((IImageControl b) -> leftMouseButtonReleaseAction.run());
    }

    @Override
    public IImageControl setLeftMouseButtonRelaseAction(Consumer<IImageControl> leftMouseButtonReleaseAction) {
        Validator.assertThat(leftMouseButtonReleaseAction).thatIsNamed("left mouse button release action").isNotNull();
        this.leftMouseButtonReleaseAction = leftMouseButtonReleaseAction;
        return this;
    }

    @Override
    public IImageControl setUserInput(String userInput) {
        throw ArgumentDoesNotSupportMethodException.forArgumentAndMethodName(this, "setUserInput");
    }

    @Override
    protected IImageControlStyle createStyle() {
        return new ImageControlStyle();
    }

    @Override
    protected IControlCssBuilder<IImageControl, IImageControlStyle> getCssBuilder() {
        return CSS_BUILDER;
    }

    @Override
    protected IControlHtmlBuilder<IImageControl> getHtmlBuilder() {
        return HTML_BUILDER;
    }

    @Override
    protected void resetControl() {
        this.clear();
        this.removeLeftMouseButtonPressAction();
        this.removeLeftMouseButtonReleaseAction();
    }
}

