/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webgui.container;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.container.matrix.Matrix;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.coreapi.state.staterequest.EmptinessRequestable;
import ch.nolix.system.element.mutableelement.AbstractMutableElement;
import ch.nolix.system.element.property.MultiValueExtractor;
import ch.nolix.system.webgui.atomiccontrol.label.Label;
import ch.nolix.system.webgui.basecontainer.AbstractContainer;
import ch.nolix.system.webgui.container.GridCell;
import ch.nolix.system.webgui.container.GridCssBuilder;
import ch.nolix.system.webgui.container.GridHtmlBuilder;
import ch.nolix.system.webgui.container.GridStyle;
import ch.nolix.systemapi.webgui.atomiccontrol.labelapi.ILabel;
import ch.nolix.systemapi.webgui.container.IGrid;
import ch.nolix.systemapi.webgui.container.IGridStyle;
import ch.nolix.systemapi.webgui.controltool.IControlCssBuilder;
import ch.nolix.systemapi.webgui.controltool.IControlHtmlBuilder;
import ch.nolix.systemapi.webgui.main.ControlState;
import ch.nolix.systemapi.webgui.main.IControl;
import ch.nolix.systemapi.webgui.main.IHtmlElementEvent;

public final class Grid
extends AbstractContainer<IGrid, IGridStyle>
implements IGrid {
    private static final String CELL_HEADER = "Cell";
    private static final GridHtmlBuilder HTML_BUILDER = new GridHtmlBuilder();
    private static final GridCssBuilder CSS_BUILDER = new GridCssBuilder();
    private Matrix<GridCell> cells = Matrix.createEmpty();
    private final MultiValueExtractor<GridCell> cellExtractor = new MultiValueExtractor<GridCell>("Cell", this::addCell, () -> this.cells.getStoredSelected(EmptinessRequestable::containsAny), GridCell::fromSpecification, AbstractMutableElement::getSpecification);

    public Grid() {
        ((IGridStyle)this.getStoredStyle()).setGridThicknessForState(ControlState.BASE, 1).setChildControlMarginForState(ControlState.BASE, 10);
    }

    @Override
    public void clear() {
        this.cells.clear();
    }

    @Override
    public boolean containsControlAtOneBasedRowAndColumnIndex(int oneBasedRowIndex, int oneBasedColumnIndex) {
        return this.cells.getStoredAtOneBasedRowIndexAndColumnIndex(oneBasedRowIndex, oneBasedColumnIndex).containsAny();
    }

    @Override
    public int getColumnCount() {
        return this.cells.getColumnCount();
    }

    @Override
    public IControl<?, ?> getStoredChildControlAtOneBasedRowAndColumnIndex(int oneBasedRowIndex, int oneBasedColumnIndex) {
        return this.cells.getStoredAtOneBasedRowIndexAndColumnIndex(oneBasedRowIndex, oneBasedColumnIndex).getStoredControl();
    }

    @Override
    public int getRowCount() {
        return this.cells.getRowCount();
    }

    @Override
    public IContainer<IControl<?, ?>> getStoredChildControls() {
        LinkedList<IControl<?, ?>> childControls = LinkedList.createEmpty();
        for (GridCell c : this.cells) {
            if (!c.containsAny()) continue;
            childControls.addAtEnd(c.getStoredControl());
        }
        return childControls;
    }

    @Override
    public IGrid insertControlAtRowAndColumn(int oneBasedRowIndex, int oneBasedColumnIndex, IControl<?, ?> control) {
        GridCell cell = GridCell.withOneBasedRowIndexAndColumnIndex(oneBasedRowIndex, oneBasedColumnIndex);
        cell.setControl(control);
        this.addCell(cell);
        cell.getStoredControl().internalSetParentControl(this);
        return this;
    }

    @Override
    public IGrid insertTextAtRowAndColumn(int rowIndex, int columnIndex, String text) {
        ILabel textControl = new Label().setText(text);
        return this.insertControlAtRowAndColumn(rowIndex, columnIndex, textControl);
    }

    @Override
    public boolean isEmpty() {
        return this.cells.isEmpty();
    }

    @Override
    public void registerHtmlElementEventsAt(ILinkedList<IHtmlElementEvent> list) {
    }

    @Override
    protected GridStyle createStyle() {
        return new GridStyle();
    }

    @Override
    protected IControlCssBuilder<IGrid, IGridStyle> getCssBuilder() {
        return CSS_BUILDER;
    }

    @Override
    protected IControlHtmlBuilder<IGrid> getHtmlBuilder() {
        return HTML_BUILDER;
    }

    @Override
    protected void resetContainer() {
        this.clear();
    }

    private void addCell(GridCell cell) {
        this.expandTo(cell.getRowIndex(), cell.getColumnIndex());
        this.cells.setAtOneBasedRowIndexAndColumnIndex(cell.getRowIndex(), cell.getColumnIndex(), cell);
    }

    private void expandTo(int rowCount, int columnCount) {
        this.expandRowsTo(rowCount);
        this.expandColumnsTo(columnCount);
    }

    private void expandColumnsTo(int columnIndex) {
        Validator.assertThat(columnIndex).thatIsNamed("column index").isPositive();
        if (this.cells.isEmpty()) {
            this.cells.addRow(GridCell.withOneBasedRowIndexAndColumnIndex(1, 1), (GridCell[])new GridCell[0]);
        }
        int ci = this.getColumnCount() + 1;
        while (ci <= columnIndex) {
            LinkedList column = LinkedList.createEmpty();
            int ri = 1;
            while (ri <= this.getRowCount()) {
                column.addAtEnd(GridCell.withOneBasedRowIndexAndColumnIndex(ri, ci));
                ++ri;
            }
            this.cells.addColumn(column);
            ++ci;
        }
    }

    private void expandRowsTo(int rowIndex) {
        Validator.assertThat(rowIndex).thatIsNamed("row index").isPositive();
        if (this.cells.isEmpty()) {
            this.cells.addRow(GridCell.withOneBasedRowIndexAndColumnIndex(1, 1), (GridCell[])new GridCell[0]);
        }
        int ri = this.getRowCount() + 1;
        while (ri <= rowIndex) {
            LinkedList row = LinkedList.createEmpty();
            int ci = 1;
            while (ci <= this.getColumnCount()) {
                row.addAtEnd(GridCell.withOneBasedRowIndexAndColumnIndex(ri, ci));
                ++ci;
            }
            this.cells.addRow(row);
            ++ri;
        }
    }
}

