/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webgui.container;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.web.cssmodel.CssProperty;
import ch.nolix.core.web.cssmodel.CssRule;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.coreapi.web.cssmodel.ICssProperty;
import ch.nolix.coreapi.web.cssmodel.ICssRule;
import ch.nolix.system.webgui.basecontroltool.AbstractControlCssBuilder;
import ch.nolix.system.webgui.controltool.ControlCssValueTool;
import ch.nolix.systemapi.graphic.color.IColor;
import ch.nolix.systemapi.webgui.container.IGrid;
import ch.nolix.systemapi.webgui.container.IGridStyle;
import ch.nolix.systemapi.webgui.main.ControlState;

public final class GridCssBuilder
extends AbstractControlCssBuilder<IGrid, IGridStyle> {
    private static final ControlCssValueTool CONTROL_CSS_VALUE_TOOL = new ControlCssValueTool();

    @Override
    protected void fillUpCssPropertiesForControlAndAllStatesIntoList(IGrid control, ILinkedList<ICssProperty> list) {
    }

    @Override
    protected void fillUpCssPropertiesForControlAndStateIntoList(IGrid control, ControlState state, ILinkedList<ICssProperty> list) {
    }

    @Override
    protected void fillUpAdditionalCssRulesForControlAndStateIntoList(IGrid control, ControlState state, ILinkedList<? super ICssRule> list) {
        IGridStyle style = (IGridStyle)control.getStoredStyle();
        int gridThickness = style.getGridThicknessWhenHasState(state);
        IColor gridcolor = style.getGridColorWhenHasState(state);
        int childControlMargin = style.getChildControlMarginWhenHasState(state);
        list.addAtEnd(CssRule.withSelectorAndProperties("table, th, td", ImmutableList.withElement(CssProperty.withNameAndValue("border-collapse", "collapse"), CssProperty.withNameAndValue("border", "solid " + gridThickness + "px"), CssProperty.withNameAndValue("border-color", CONTROL_CSS_VALUE_TOOL.getCssValueFromColor(gridcolor)))));
        list.addAtEnd(CssRule.withSelectorAndProperties("td", ImmutableList.withElement(CssProperty.withNameAndValue("padding", childControlMargin + "px"), new CssProperty[0])));
    }

    @Override
    protected void fillUpAdditionalCssRulesForControlAndAllStatesIntoList(IGrid control, ILinkedList<? super ICssRule> list) {
    }
}

