/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webgui.itemmenu.base;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.state.staterequest.BlanknessRequestable;
import ch.nolix.system.element.property.MultiValue;
import ch.nolix.system.webgui.itemmenu.base.ItemMenuItem;
import ch.nolix.system.webgui.itemmenu.base.ItemMenuSearcher;
import ch.nolix.system.webgui.itemmenu.base.ItemMenuValidator;
import ch.nolix.system.webgui.main.Control;
import ch.nolix.systemapi.element.base.IElement;
import ch.nolix.systemapi.gui.model.CursorIcon;
import ch.nolix.systemapi.gui.selection.Selectable;
import ch.nolix.systemapi.gui.selection.SelectionRequestable;
import ch.nolix.systemapi.webgui.itemmenu.baseapi.IItemMenu;
import ch.nolix.systemapi.webgui.itemmenu.baseapi.IItemMenuItem;
import ch.nolix.systemapi.webgui.itemmenu.baseapi.IItemMenuSearcher;
import ch.nolix.systemapi.webgui.itemmenu.baseapi.IItemMenuStyle;
import ch.nolix.systemapi.webgui.itemmenu.baseapi.IItemMenuValidator;
import ch.nolix.systemapi.webgui.main.IControl;
import java.util.function.Consumer;

public abstract class AbstractItemMenu<M extends IItemMenu<M, S>, S extends IItemMenuStyle<S>>
extends Control<M, S>
implements IItemMenu<M, S> {
    private static final String ITEM_HEADER = "Item";
    private static final IItemMenuSearcher ITEM_MENU_SEARCHER = new ItemMenuSearcher();
    private static final IItemMenuValidator ITEM_MENU_VALIDATOR = new ItemMenuValidator();
    private final MultiValue<IItemMenuItem<?>> items = new MultiValue<IItemMenuItem>("Item", iItemMenuItem -> {
        M m = this.addItem((IItemMenuItem<?>)iItemMenuItem, new IItemMenuItem[0]);
    }, ItemMenuItem::fromSpecification, IElement::getSpecification);
    private Consumer<IItemMenuItem<?>> selectAction;

    @Override
    public final M addBlankItem() {
        return this.addItem(ItemMenuItem.createBlankItem(), new IItemMenuItem[0]);
    }

    @Override
    public final M addItem(IItemMenuItem<?> item, IItemMenuItem<?> ... items) {
        ContainerView<IItemMenuItem<?>> allItems = ContainerView.forElementAndArray(item, items);
        for (IItemMenuItem iItemMenuItem : allItems) {
            ITEM_MENU_VALIDATOR.assertCanAddItem(this, iItemMenuItem);
            iItemMenuItem.internalSetParentMenu(this);
            this.items.add(iItemMenuItem);
        }
        return (M)((IItemMenu)this.asConcrete());
    }

    @Override
    public final M addItemWithIdAndText(String id, String text) {
        return this.addItem(ItemMenuItem.withIdAndText(id, text), new IItemMenuItem[0]);
    }

    @Override
    public final M addItemWithIdAndTextAndSelectAction(String id, String text, Runnable selectAction) {
        return this.addItem(ItemMenuItem.withIdAndTextAndSelectAction(id, text, selectAction), new IItemMenuItem[0]);
    }

    @Override
    public final M addItemWithIdAndTextAndSelectAction(String id, String text, Consumer<IItemMenuItem<?>> selectAction) {
        return this.addItem(ItemMenuItem.withIdAndTextAndSelectAction(id, text, selectAction), new IItemMenuItem[0]);
    }

    @Override
    public final M addItemWithText(String text, String ... texts) {
        ContainerView<String> allTexts = ContainerView.forElementAndArray(text, texts);
        for (String t : allTexts) {
            this.addItem(ItemMenuItem.withText(t), new IItemMenuItem[0]);
        }
        return (M)((IItemMenu)this.asConcrete());
    }

    @Override
    public final M addItemWithTextAndSelectAction(String text, Runnable selectAction) {
        return this.addItem(ItemMenuItem.withTextAndSelectAction(text, selectAction), new IItemMenuItem[0]);
    }

    @Override
    public final M addItemWithTextAndSelectAction(String text, Consumer<IItemMenuItem<?>> selectAction) {
        return this.addItem(ItemMenuItem.withTextAndSelectAction(text, selectAction), new IItemMenuItem[0]);
    }

    @Override
    public final boolean blankItemIsSelected() {
        return this.containsBlankItem() && ITEM_MENU_SEARCHER.getStoredBlankItem(this).isSelected();
    }

    @Override
    public final void clear() {
        this.items.clear();
    }

    @Override
    public final boolean containsBlankItem() {
        return this.getStoredItems().containsAny(BlanknessRequestable::isBlank);
    }

    @Override
    public final boolean containsItemWithId(String id) {
        return this.getStoredItems().containsAny(i -> i.hasId(id));
    }

    @Override
    public final boolean containsItemWithText(String text) {
        return this.getStoredItems().containsAny(i -> i.getText().equals(text));
    }

    @Override
    public final boolean containsSelectedItem() {
        return this.getStoredItems().containsAny(SelectionRequestable::isSelected);
    }

    @Override
    public final String getIdByItemText(String itemText) {
        return ITEM_MENU_SEARCHER.getStoredItemByText(this, itemText).getId();
    }

    @Override
    public final IContainer<IControl<?, ?>> getStoredChildControls() {
        return ImmutableList.createEmpty();
    }

    @Override
    public final IContainer<IItemMenuItem<?>> getStoredItems() {
        return this.items.getStoredValues();
    }

    @Override
    public final IItemMenuItem<?> getStoredSelectedItem() {
        return this.getStoredItems().getStoredFirst(SelectionRequestable::isSelected);
    }

    @Override
    public final String getTextByItemId(String itemId) {
        return ITEM_MENU_SEARCHER.getStoredItemById(this, itemId).getText();
    }

    @Override
    public final String getUserInput() {
        if (this.isEmpty()) {
            return "";
        }
        return this.getStoredItems().getStoredFirst(SelectionRequestable::isSelected).getText();
    }

    @Override
    public final boolean hasRole(String role) {
        return false;
    }

    @Override
    public final boolean isEmpty() {
        return this.getStoredItems().isEmpty();
    }

    @Override
    public final void removeSelectAction() {
        this.selectAction = null;
    }

    @Override
    public final void runHtmlEvent(String htmlEvent) {
        Validator.assertThat(htmlEvent).thatIsNamed("HTML event").isEqualTo("onchange");
    }

    @Override
    public final M selectBlankItem() {
        IItemMenuItem<?> blankItem = ITEM_MENU_SEARCHER.getStoredBlankItem(this);
        blankItem.select();
        return (M)((IItemMenu)this.asConcrete());
    }

    @Override
    public final M selectFirstItem() {
        IItemMenuItem<?> firstItem = ITEM_MENU_SEARCHER.getStoredFirstItem(this);
        firstItem.select();
        return (M)((IItemMenu)this.asConcrete());
    }

    @Override
    public final M selectItemById(String id) {
        IItemMenuItem<?> item = ITEM_MENU_SEARCHER.getStoredItemById(this, id);
        item.select();
        return (M)((IItemMenu)this.asConcrete());
    }

    @Override
    public final M selectItemByText(String text) {
        IItemMenuItem<?> item = ITEM_MENU_SEARCHER.getStoredItemByText(this, text);
        item.select();
        return (M)((IItemMenu)this.asConcrete());
    }

    @Override
    public final M setSelectAction(Runnable selectAction) {
        Validator.assertThat(selectAction).thatIsNamed("select action").isNotNull();
        return this.setSelectAction((IItemMenuItem<?> i) -> selectAction.run());
    }

    @Override
    public final M setSelectAction(Consumer<IItemMenuItem<?>> selectAction) {
        Validator.assertThat(selectAction).thatIsNamed("select action").isNotNull();
        this.selectAction = selectAction;
        return (M)((IItemMenu)this.asConcrete());
    }

    @Override
    public final M setUserInput(String userInput) {
        if (userInput.isEmpty()) {
            this.getStoredItems().forEach(Selectable::unselect);
        } else {
            this.selectItemByText(userInput);
        }
        return (M)((IItemMenu)this.asConcrete());
    }

    @Override
    public final void internalRunOptionalSelectActionForItem(IItemMenuItem<?> item) {
        if (this.hasSelectAction()) {
            this.selectAction.accept(item);
        }
    }

    @Override
    protected final void resetControl() {
        this.clear();
        this.removeSelectAction();
        this.setCursorIcon(CursorIcon.HAND);
    }

    private boolean hasSelectAction() {
        return this.selectAction != null;
    }
}

