/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webgui.main;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.independent.math.NumberComparator;
import ch.nolix.core.web.cssmodel.CssProperty;
import ch.nolix.core.web.cssmodel.CssRule;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.web.cssmodel.ICssProperty;
import ch.nolix.systemapi.gui.box.ContentAlignment;
import ch.nolix.systemapi.webgui.main.ILayer;
import ch.nolix.systemapi.webgui.main.IWebGui;

public final class LayerCssBuilder {
    public CssRule getCssRuleForLayer(ILayer<?> layer) {
        return CssRule.withSelectorAndProperties(this.getCssSelectorForLayer(layer), this.getCssPropertiesForLayer(layer));
    }

    private String getCssSelectorForLayer(ILayer<?> layer) {
        return "#" + layer.getInternalId();
    }

    private IContainer<ICssProperty> getCssPropertiesForLayer(ILayer<?> layer) {
        LinkedList<ICssProperty> cssProperties = LinkedList.createEmpty();
        if (((IWebGui)layer.getStoredParentGui()).getStoredTopLayer() == layer) {
            cssProperties.addAtEnd(CssProperty.withNameAndValue("position", "absolute"));
        } else {
            cssProperties.addAtEnd(CssProperty.withNameAndValue("position", "fixed"));
        }
        if (!NumberComparator.isOne(layer.getOpacity())) {
            cssProperties.addAtEnd(CssProperty.withNameAndValue("opacity", layer.getOpacity()));
        }
        cssProperties.addAtEnd(this.getZIndexCssPropertyForLayer(layer), CssProperty.withNameAndValue("min-width", "100vw"), CssProperty.withNameAndValue("min-height", "100vh"), CssProperty.withNameAndValue("display", "flex"), this.getJustifyContentCssPropertyForLayer(layer), this.getAlignItemsCssPropertyForLayer(layer));
        if (layer.hasBackground()) {
            cssProperties.addAtEnd(layer.getBackground().toCssProperties());
        }
        return cssProperties;
    }

    private CssProperty getZIndexCssPropertyForLayer(ILayer<?> layer) {
        return CssProperty.withNameAndValue("z-index", this.getCssZIndexForLayer(layer));
    }

    private int getCssZIndexForLayer(ILayer<?> layer) {
        if (!layer.belongsToGui()) {
            return 0;
        }
        return ((IWebGui)layer.getStoredParentGui()).getStoredLayers().getOneBasedIndexOfFirstOccurrenceOf(layer);
    }

    private CssProperty getJustifyContentCssPropertyForLayer(ILayer<?> layer) {
        return this.getJustifyContentCssPropertyForContentAlignment(layer.getContentAlignment());
    }

    private CssProperty getJustifyContentCssPropertyForContentAlignment(ContentAlignment contentAlignment) {
        return switch (contentAlignment) {
            case ContentAlignment.TOP_LEFT, ContentAlignment.LEFT, ContentAlignment.BOTTOM_LEFT -> CssProperty.withNameAndValue("justify-content", "left");
            case ContentAlignment.TOP, ContentAlignment.CENTER, ContentAlignment.BOTTOM -> CssProperty.withNameAndValue("justify-content", "center");
            case ContentAlignment.TOP_RIGHT, ContentAlignment.RIGHT, ContentAlignment.BOTTOM_RIGHT -> CssProperty.withNameAndValue("justify-content", "right");
            default -> throw InvalidArgumentException.forArgument((Object)contentAlignment);
        };
    }

    private CssProperty getAlignItemsCssPropertyForLayer(ILayer<?> layer) {
        return this.getAlignItemsCssPropertyForContentAlignment(layer.getContentAlignment());
    }

    private CssProperty getAlignItemsCssPropertyForContentAlignment(ContentAlignment contentAlignment) {
        return switch (contentAlignment) {
            case ContentAlignment.BOTTOM_LEFT, ContentAlignment.BOTTOM, ContentAlignment.BOTTOM_RIGHT -> CssProperty.withNameAndValue("align-items", "end");
            case ContentAlignment.LEFT, ContentAlignment.CENTER, ContentAlignment.RIGHT -> CssProperty.withNameAndValue("align-items", "center");
            case ContentAlignment.TOP_LEFT, ContentAlignment.TOP, ContentAlignment.TOP_RIGHT -> CssProperty.withNameAndValue("align-items", "start");
            default -> throw InvalidArgumentException.forArgument((Object)contentAlignment);
        };
    }
}

