/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.tech.math.bigdecimalmath;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.tech.math.bigdecimalmath.AbstractSequence;
import ch.nolix.techapi.math.bigdecimalmath.IComplexNumber;
import ch.nolix.techapi.math.bigdecimalmath.ISequenceDefinedBy1Predecessor;
import java.math.BigDecimal;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public final class ComplexSequenceDefinedBy1Predecessor
extends AbstractSequence<IComplexNumber>
implements ISequenceDefinedBy1Predecessor<IComplexNumber> {
    private final IComplexNumber firstValue;
    private final Function<IComplexNumber, IComplexNumber> nextValueFunction;

    private ComplexSequenceDefinedBy1Predecessor(IComplexNumber firstValue, UnaryOperator<IComplexNumber> nextValueFunction) {
        Validator.assertThat(firstValue).thatIsNamed("first value").isNotNull();
        Validator.assertThat(nextValueFunction).thatIsNamed("next value function").isNotNull();
        this.firstValue = firstValue;
        this.nextValueFunction = nextValueFunction;
    }

    public static ComplexSequenceDefinedBy1Predecessor withFirstValueAndNextValueFunction(IComplexNumber firstValue, UnaryOperator<IComplexNumber> nextValueFunction) {
        return new ComplexSequenceDefinedBy1Predecessor(firstValue, nextValueFunction);
    }

    @Override
    public IComplexNumber getFirstValue() {
        return this.firstValue;
    }

    @Override
    protected BigDecimal calculateSquaredMagnitudeForValue(IComplexNumber value) {
        return value.getSquaredMagnitude();
    }

    @Override
    protected IComplexNumber calculateValue(int index) {
        if (index == 1) {
            return this.getFirstValue();
        }
        IComplexNumber predecessor = (IComplexNumber)this.getValueAtIndexWhenCalculated(index - 1);
        return this.nextValueFunction.apply(predecessor);
    }
}

