/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.commontypetool.arraytool;

import ch.nolix.core.commontypetool.iteratorvalidator.IteratorValidator;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.iterator.CopyableIterator;
import java.util.NoSuchElementException;

public final class ArrayIterator<E>
implements CopyableIterator<E> {
    private static final IteratorValidator ITERATOR_VALIDATOR = new IteratorValidator();
    private final E[] parentArray;
    private int nextIndex;

    private ArrayIterator(E[] parrentArray) {
        Validator.assertThat(parrentArray).thatIsNamed("parent array").isNotNull();
        this.parentArray = parrentArray;
        this.nextIndex = 0;
    }

    private ArrayIterator(E[] parrentArray, int startIndex) {
        Validator.assertThat(parrentArray).thatIsNamed("parent array").isNotNull();
        Validator.assertThat(startIndex).thatIsNamed("start index").isNotNegative();
        this.parentArray = parrentArray;
        this.nextIndex = startIndex;
    }

    public static <E2> ArrayIterator<E2> forArray(E2[] array) {
        return new ArrayIterator<E2>(array);
    }

    public static <E2> ArrayIterator<E2> forArrayAndStartIndex(E2[] array, int startIndex) {
        return new ArrayIterator<E2>(array, startIndex);
    }

    @Override
    public CopyableIterator<E> getCopy() {
        return ArrayIterator.forArrayAndStartIndex(this.parentArray, this.nextIndex);
    }

    @Override
    public boolean hasNext() {
        return this.nextIndex < this.parentArray.length;
    }

    @Override
    public E next() {
        this.assertHasNext();
        return this.nextWhenHasNext();
    }

    private void assertHasNext() throws NoSuchElementException {
        ITERATOR_VALIDATOR.assertHasNext(this);
    }

    private E nextWhenHasNext() {
        E element = this.parentArray[this.nextIndex];
        ++this.nextIndex;
        return element;
    }
}

