/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.arraylist;

import ch.nolix.core.container.arraylist.AbstractExtendedContainer;
import ch.nolix.core.container.arraylist.IntervallContainerViewIterator;
import ch.nolix.core.container.base.AbstractContainer;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.iterator.CopyableIterator;

public final class IntervallContainerView<E>
extends AbstractExtendedContainer<E> {
    private final AbstractContainer<E> abstractContainer;
    private final int startIndex;
    private final int endIndex;

    private IntervallContainerView(AbstractContainer<E> container, int startIndex, int endIndex) {
        Validator.assertThat(container).thatIsNamed("container").isNotNull();
        Validator.assertThat(startIndex).thatIsNamed("start index").isPositive();
        Validator.assertThat(endIndex).thatIsNamed("end index").isPositive();
        Validator.assertThat(endIndex).thatIsNamed("end index").isBiggerThanOrEquals(startIndex);
        Validator.assertThat(endIndex).thatIsNamed("end index").isNotBiggerThan(container.getCount());
        this.abstractContainer = container;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public static <E2> IntervallContainerView<E2> forContainerAndStartIndexAndEndIndex(AbstractContainer<E2> container, int startIndex, int endIndex) {
        return new IntervallContainerView<E2>(container, startIndex, endIndex);
    }

    @Override
    public int getCount() {
        return this.endIndex - this.startIndex + 1;
    }

    @Override
    public E getStoredAtOneBasedIndex(int oneBasedIndex) {
        Validator.assertThat(oneBasedIndex).thatIsNamed("index").isPositive();
        Validator.assertThat(oneBasedIndex).thatIsNamed("index").isNotBiggerThan(this.getCount());
        return this.abstractContainer.getStoredAtOneBasedIndex(this.startIndex + oneBasedIndex - 1);
    }

    @Override
    public boolean isMaterialized() {
        return false;
    }

    @Override
    public CopyableIterator<E> iterator() {
        return new IntervallContainerViewIterator<E>(this.abstractContainer, this.startIndex, this.endIndex);
    }

    public String toString() {
        return this.toStringWithSeparator(',');
    }
}

