/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.containerview;

import ch.nolix.core.commontypetool.arraytool.ArrayIterator;
import ch.nolix.core.container.arraylist.AbstractExtendedContainer;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.iterator.CopyableIterator;

public final class ArrayContainerView<E>
extends AbstractExtendedContainer<E> {
    private final E[] array;

    private ArrayContainerView(E[] array) {
        Validator.assertThat(array).thatIsNamed("array").isNotNull();
        this.array = array;
    }

    public static <E2> ArrayContainerView<E2> createEmpty() {
        return ArrayContainerView.forArray(new Object[0]);
    }

    public static <E2> ArrayContainerView<E2> forArray(E2[] array) {
        return new ArrayContainerView<E2>(array);
    }

    @Override
    public int getCount() {
        return this.array.length;
    }

    @Override
    public E getStoredAtOneBasedIndex(int oneBasedIndex) {
        Validator.assertThat(oneBasedIndex).thatIsNamed("1-based index").isBetween(0, this.getCount());
        return this.array[oneBasedIndex - 1];
    }

    @Override
    public boolean isMaterialized() {
        return false;
    }

    @Override
    public CopyableIterator<E> iterator() {
        return ArrayIterator.forArray(this.array);
    }

    public String toString() {
        return this.toStringWithSeparator(',');
    }
}

