/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.linkedlist;

import ch.nolix.core.commontypetool.iteratortool.IterableExaminer;
import ch.nolix.core.container.arraylist.AbstractExtendedContainer;
import ch.nolix.core.container.linkedlist.LinkedListIterator;
import ch.nolix.core.container.linkedlist.LinkedListNode;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotContainElementException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsOutOfRangeException;
import ch.nolix.core.errorcontrol.invalidargumentexception.EmptyArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.commontypetool.iterabletool.IIterableExaminer;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.iterator.CopyableIterator;
import ch.nolix.coreapi.container.list.ILinkedList;
import java.util.function.Predicate;

public final class LinkedList<E>
extends AbstractExtendedContainer<E>
implements ILinkedList<E> {
    private static final IIterableExaminer ITERABLE_EXAMINER = new IterableExaminer();
    private int elementCount;
    private LinkedListNode<E> firstNode;
    private LinkedListNode<E> lastNode;

    private LinkedList() {
    }

    public static <E2> LinkedList<E2> createEmpty() {
        return new LinkedList();
    }

    public static <E2> LinkedList<E2> fromArray(E2[] array) {
        Validator.assertThat(array).thatIsNamed("array").isNotNull();
        LinkedList<E2> list = new LinkedList<E2>();
        list.addAtEnd(array);
        return list;
    }

    public static <E2> LinkedList<E2> fromIterable(Iterable<E2> container) {
        LinkedList<E2> list = new LinkedList<E2>();
        list.addAtEnd(container);
        return list;
    }

    public static <E2> LinkedList<E2> withElement(E2 element, E2 ... elements) {
        LinkedList<E2> list = new LinkedList<E2>();
        list.addAtEnd(element, elements);
        return list;
    }

    @Override
    public void addAtBegin(E element) {
        LinkedListNode<E> node = new LinkedListNode<E>(element);
        if (this.isEmpty()) {
            this.firstNode = node;
            this.lastNode = node;
        } else {
            node.setNextNode(this.firstNode);
            this.firstNode = node;
        }
        ++this.elementCount;
    }

    @Override
    public void addAtBegin(E element, E ... elements) {
        this.addAtBegin(elements);
        this.addAtBegin(element);
    }

    @Override
    public void addAtBegin(E[] elements) {
        if (this.isEmpty()) {
            this.addAtBeginWhenIsEmpty(elements);
        } else {
            this.addAtBeginWhenContainsAny(elements);
        }
    }

    @Override
    public void addAtBegin(Iterable<? extends E> elements) {
        Validator.assertThat(elements).thatIsNamed("elements").isNotNull();
        if (ITERABLE_EXAMINER.containsAny(elements)) {
            LinkedListNode<E> newFirstNode = new LinkedListNode<E>(elements.iterator().next());
            LinkedListNode<E> node = null;
            for (E e : elements) {
                if (node == null) {
                    node = newFirstNode;
                } else {
                    LinkedListNode<E> currentNode = new LinkedListNode<E>(e);
                    node.setNextNode(currentNode);
                    node = currentNode;
                }
                ++this.elementCount;
            }
            if (node != null && this.firstNode != null) {
                node.setNextNode(this.firstNode);
            }
            this.firstNode = newFirstNode;
            if (this.lastNode == null) {
                this.lastNode = node;
            }
        }
    }

    @Override
    public void addAtEnd(E element) {
        LinkedListNode<E> node = new LinkedListNode<E>(element);
        if (this.isEmpty()) {
            this.firstNode = node;
            this.lastNode = node;
        } else {
            this.lastNode.setNextNode(node);
            this.lastNode = node;
        }
        ++this.elementCount;
    }

    @Override
    @SafeVarargs
    public final void addAtEnd(E element, E ... elements) {
        this.addAtEnd(element);
        E[] EArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            E e = EArray[n2];
            this.addAtEnd(e);
            ++n2;
        }
    }

    @Override
    public void addAtEnd(E[] elements) {
        E[] EArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            E e = EArray[n2];
            this.addAtEnd(e);
            ++n2;
        }
    }

    @Override
    public void addAtEnd(Iterable<? extends E> elements) {
        elements.forEach(this::addAtEnd);
    }

    @Override
    public void clear() {
        if (this.containsAny()) {
            LinkedListNode<E> iterator = this.firstNode;
            while (iterator.hasNextNode()) {
                LinkedListNode<E> nextNode = iterator.getNextNode();
                iterator.removeNextNode();
                iterator = nextNode;
            }
            this.firstNode = null;
            this.lastNode = null;
            this.elementCount = 0;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof LinkedList) {
            LinkedList linkedList = (LinkedList)object;
            return this.containsExactlyInSameOrder(linkedList);
        }
        return false;
    }

    @Override
    public ILinkedList<E> getCopy() {
        LinkedList copy = new LinkedList();
        for (Object e : this) {
            copy.addAtEnd(e);
        }
        return copy;
    }

    @Override
    public int getCount() {
        return this.elementCount;
    }

    @Override
    public E getStoredAtOneBasedIndex(int oneBasedIndex) {
        this.assertContainsAny();
        if (oneBasedIndex == this.getCount()) {
            return this.lastNode.getElement();
        }
        int index = 1;
        for (Object e : this) {
            if (index == oneBasedIndex) {
                return e;
            }
            ++index;
        }
        throw ArgumentIsOutOfRangeException.forArgumentAndArgumentNameAndRangeWithMinAndMax(oneBasedIndex, "1-based index", 1L, this.getCount());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean isMaterialized() {
        return true;
    }

    @Override
    public CopyableIterator<E> iterator() {
        return LinkedListIterator.withNullableFirstNode(this.firstNode);
    }

    @Override
    public void removeAll(Predicate<E> selector) {
        IContainer<E> remainingElements = this.getStoredOthers(selector);
        this.clear();
        this.addAtEnd((Iterable<? extends E>)remainingElements);
    }

    @Override
    public void removeAllOccurrencesOf(Object element) {
        this.removeAll(e -> e == element);
    }

    @Override
    public E removeAndGetStoredFirst() {
        Object element = this.getStoredFirst();
        this.removeFirst();
        return element;
    }

    @Override
    public E removeAndGetStoredFirst(Predicate<E> selector) {
        E element = this.getStoredFirst(selector);
        this.removeFirst(selector);
        return element;
    }

    @Override
    public E removeAndGetStoredLast() {
        Object element = this.getStoredLast();
        this.removeLast();
        return element;
    }

    @Override
    public void removeFirst() {
        switch (this.getCount()) {
            case 0: {
                break;
            }
            case 1: {
                this.clear();
                break;
            }
            default: {
                this.firstNode = this.firstNode.getNextNode();
                --this.elementCount;
            }
        }
    }

    @Override
    public void removeFirstStrictly() {
        switch (this.getCount()) {
            case 0: {
                throw EmptyArgumentException.forArgument(this);
            }
            case 1: {
                this.clear();
                break;
            }
            default: {
                this.firstNode = this.firstNode.getNextNode();
                --this.elementCount;
            }
        }
    }

    @Override
    public void removeFirst(Predicate<E> selector) {
        if (this.containsAny()) {
            this.removeFirstWhenContainsAny(selector);
        }
    }

    @Override
    public void removeFirstOccurrenceOf(Object element) {
        if (this.containsAny()) {
            this.removeFirstOccurrenceOfWhenContainsAny(element);
        }
    }

    @Override
    public void removeLast() {
        if (this.containsAny()) {
            this.removeLastWhenContainsAny();
        }
    }

    @Override
    public void removeLastStrictly() {
        this.assertContainsAny();
        this.removeLastWhenContainsAny();
    }

    @Override
    public void removeStrictlyFirstOccurrenceOf(Object element) {
        if (this.containsAny()) {
            this.removeStrictlyFirstOccurrenceOfWhenContainsAny(element);
        }
    }

    @Override
    public void replaceFirst(Predicate<E> selector, E element) {
        LinkedListNode<E> iterator = this.firstNode;
        while (true) {
            if (selector.test(iterator.getElement())) {
                iterator.setElement(element);
                break;
            }
            if (!iterator.hasNextNode()) break;
            iterator = iterator.getNextNode();
        }
    }

    public String toString() {
        return this.toStringWithSeparator(',');
    }

    private void addAtBeginWhenContainsAny(E[] elements) {
        LinkedListNode<E> newFirstNode = null;
        LinkedListNode<E> iteratorNode = null;
        E[] EArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            E e = EArray[n2];
            LinkedListNode<E> newNode = new LinkedListNode<E>(e);
            if (iteratorNode == null) {
                newFirstNode = newNode;
            } else {
                iteratorNode.setNextNode(newNode);
            }
            iteratorNode = newNode;
            ++n2;
        }
        if (newFirstNode != null) {
            iteratorNode.setNextNode(this.firstNode);
            this.firstNode = newFirstNode;
        }
        this.elementCount += elements.length;
    }

    private void addAtBeginWhenIsEmpty(E[] elements) {
        LinkedListNode<E> iteratorNode = null;
        E[] EArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            E e = EArray[n2];
            LinkedListNode<E> newNode = new LinkedListNode<E>(e);
            if (iteratorNode == null) {
                this.firstNode = newNode;
            } else {
                iteratorNode.setNextNode(newNode);
            }
            iteratorNode = newNode;
            ++n2;
        }
        this.lastNode = iteratorNode;
        this.elementCount += elements.length;
    }

    private void assertContainsAny() {
        if (this.isEmpty()) {
            throw EmptyArgumentException.forArgument(this);
        }
    }

    private void removeFirstOccurrenceOfWhenContainsAny(Object element) {
        if (this.firstNode.contains(element)) {
            this.removeFirst();
        } else {
            LinkedListNode<E> iterator = this.firstNode;
            while (iterator.hasNextNode()) {
                LinkedListNode<E> nextNode = iterator.getNextNode();
                if (nextNode.contains(element)) {
                    this.removeNextNode(iterator);
                    break;
                }
                iterator = nextNode;
            }
        }
    }

    private void removeFirstWhenContainsAny(Predicate<E> selector) {
        if (selector.test(this.getStoredFirst())) {
            this.removeFirst();
        } else {
            LinkedListNode<E> iterator = this.firstNode;
            while (iterator.hasNextNode()) {
                LinkedListNode<E> nextNode = iterator.getNextNode();
                if (selector.test(nextNode.getElement())) {
                    this.removeNextNode(iterator);
                    break;
                }
                iterator = nextNode;
            }
        }
    }

    private void removeLastWhenContainsAny() {
        if (this.containsOne()) {
            this.clear();
        } else {
            LinkedListNode<E> iterator = this.firstNode;
            while (iterator.getNextNode() != this.lastNode) {
                iterator = iterator.getNextNode();
            }
            iterator.removeNextNode();
            this.lastNode = iterator;
            --this.elementCount;
        }
    }

    private void removeNextNode(LinkedListNode<E> node) {
        Validator.assertThat(node).thatIsNamed("node").isNotNull();
        LinkedListNode<E> nextNode = node.getNextNode();
        if (nextNode.hasNextNode()) {
            node.setNextNode(nextNode.getNextNode());
        } else {
            node.removeNextNode();
            this.lastNode = node;
        }
        --this.elementCount;
    }

    private void removeStrictlyFirstOccurrenceOfWhenContainsAny(Object element) {
        if (!this.firstNode.contains(element)) {
            LinkedListNode<E> iterator = this.firstNode;
            while (iterator.hasNextNode()) {
                LinkedListNode<E> nextNode = iterator.getNextNode();
                if (nextNode.contains(element)) {
                    this.removeNextNode(iterator);
                    return;
                }
                iterator = nextNode;
            }
            throw ArgumentDoesNotContainElementException.forArgumentAndElement(this, element);
        }
        this.removeFirst();
    }
}

