/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.matrix;

import ch.nolix.core.container.matrix.MatrixRow;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.iterator.CopyableIterator;
import java.util.NoSuchElementException;

final class MatrixRowIterator<E>
implements CopyableIterator<E> {
    private final MatrixRow<E> parentMatrixRow;
    private int nextElementOneBasedColumnIndex;

    private MatrixRowIterator(MatrixRow<E> parentMatrixRow) {
        Validator.assertThat(parentMatrixRow).thatIsNamed("parent MatrixRow").isNotNull();
        this.parentMatrixRow = parentMatrixRow;
        this.nextElementOneBasedColumnIndex = 1;
    }

    private MatrixRowIterator(MatrixRow<E> parentMatrixRow, int nextElementOneBasedColumnIndex) {
        Validator.assertThat(parentMatrixRow).thatIsNamed("parent MatrixRow").isNotNull();
        Validator.assertThat(nextElementOneBasedColumnIndex).thatIsNamed("next element 1-based column index").isPositive();
        this.parentMatrixRow = parentMatrixRow;
        this.nextElementOneBasedColumnIndex = nextElementOneBasedColumnIndex;
    }

    public static <E2> MatrixRowIterator<E2> forMatrixRow(MatrixRow<E2> matrixRow) {
        return new MatrixRowIterator<E2>(matrixRow);
    }

    @Override
    public CopyableIterator<E> getCopy() {
        return new MatrixRowIterator<E>(this.parentMatrixRow, this.nextElementOneBasedColumnIndex);
    }

    @Override
    public boolean hasNext() {
        return this.nextElementOneBasedColumnIndex <= this.parentMatrixRow.getCount();
    }

    @Override
    public E next() {
        this.assertHasNext();
        return this.nextWhenHasNext();
    }

    private void assertHasNext() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "next element").toNoSuchElementException();
        }
    }

    private E nextWhenHasNext() {
        E element = this.parentMatrixRow.getStoredAtOneBasedIndex(this.nextElementOneBasedColumnIndex);
        ++this.nextElementOneBasedColumnIndex;
        return element;
    }
}

