/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.singlecontainer;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.coreapi.container.iterator.CopyableIterator;
import java.util.NoSuchElementException;

public final class SingleContainerIterator<E>
implements CopyableIterator<E> {
    private E nullableElement;

    private SingleContainerIterator(E nullableElement) {
        this.nullableElement = nullableElement;
    }

    public static <E2> SingleContainerIterator<E2> forNullableElement(E2 nullableElement) {
        return new SingleContainerIterator<E2>(nullableElement);
    }

    @Override
    public CopyableIterator<E> getCopy() {
        return SingleContainerIterator.forNullableElement(this.nullableElement);
    }

    @Override
    public boolean hasNext() {
        return this.nullableElement != null;
    }

    @Override
    public E next() {
        this.assertHasNext();
        E localElement = this.nullableElement;
        this.nullableElement = null;
        return localElement;
    }

    private void assertHasNext() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "next element").toNoSuchElementException();
        }
    }
}

